/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components.tags;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.PageContext;

public class HtmlTag {
    protected static String DEFAULT_INDENT = "  ";
    protected static String NO_INDENT = "no";
    private String name;
    private String text = "";
    private Map<String, String> attributes = new HashMap<String, String>();
    private List<HtmlTag> children = new ArrayList<HtmlTag>();
    private boolean visible = true;
    private boolean indented = true;
    private String preprendedComment;

    private HtmlTag() {
    }

    public HtmlTag(String name) {
        this();
        this.name = name;
    }

    public HtmlTag(String name, String text) {
        this(name);
        this.text = text;
    }

    public String getPreprendedComment() {
        return this.preprendedComment;
    }

    public void setPreprendedComment(String preprendedComment) {
        this.preprendedComment = preprendedComment;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isIndented() {
        return this.indented;
    }

    public void setIndented(boolean idented) {
        this.indented = idented;
    }

    public void copyAttributes(HtmlTag tag) {
        this.attributes.putAll(tag.attributes);
    }

    public void setAttribute(String name, String value) {
        if (name != null && value != null) {
            this.attributes.put(name, value);
        }
    }

    public void setAttribute(String name, Boolean value) {
        if (value != null) {
            this.setAttribute(name, value.toString().toLowerCase());
        }
    }

    public void setAttribute(String name, Number value) {
        if (value != null) {
            this.setAttribute(name, value.toString());
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public boolean hasVisibleAttributes() {
        return this.attributes.keySet().size() > 0;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void addChild(HtmlTag tag) {
        this.children.add(tag);
    }

    public List<HtmlTag> getChildren() {
        return this.children;
    }

    public void writeTag(PageContext context) throws IOException {
        this.writeTag((Writer)context.getOut());
    }

    public void writeTag(Writer writer) throws IOException {
        this.writeTag(writer, "");
    }

    public void writeTag(Writer writer, String indent) throws IOException {
        if (indent.equals(NO_INDENT)) {
            this.setIndented(false);
        }
        if (this.isVisible()) {
            this.writeOpenTag(writer, indent);
            this.writeBody(writer, indent);
            this.writeCloseTag(writer, indent);
        }
    }

    protected void writeBody(Writer writer, String indent) throws IOException {
        if (this.getChildren().size() > 0 && this.isIndented()) {
            writer.write(10);
        }
        for (HtmlTag child : this.getChildren()) {
            if (this.isIndented()) {
                child.writeTag(writer, indent + DEFAULT_INDENT);
                writer.write(10);
                continue;
            }
            child.writeTag(writer, NO_INDENT);
        }
    }

    protected void writeOpenTag(Writer writer, String indent) throws IOException {
        if (this.getPreprendedComment() != null) {
            writer.write(this.getPreprendedComment());
        }
        if (this.isIndented()) {
            writer.write(indent);
        }
        if (this.name != null) {
            writer.write(60);
            writer.write(this.name);
            for (Map.Entry<String, String> attributeEntry : this.attributes.entrySet()) {
                String attributeName = attributeEntry.getKey();
                String attributeValue = attributeEntry.getValue();
                if (attributeValue == null) continue;
                writer.write(32);
                writer.write(attributeName);
                writer.write("=\"");
                writer.write(attributeValue);
                writer.write(34);
            }
            writer.write(62);
        }
        if (this.text != null) {
            writer.write(this.text);
        }
    }

    protected void writeCloseTag(Writer writer, String indent) throws IOException {
        if (this.children.size() > 0 && this.isIndented()) {
            writer.write(indent);
        }
        if (this.name != null) {
            writer.write("</");
            writer.write(this.name);
            writer.write(62);
        }
    }
}

