/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class BooleanInputRenderer
extends InputRenderer {
    private boolean disabled;
    private String bundle;
    private String bodyText;

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlCheckBox checkBox = new HtmlCheckBox();
                checkBox.setChecked(object == null ? false : (Boolean)object);
                checkBox.setText(RenderUtils.getResourceString(BooleanInputRenderer.this.getBundle(), BooleanInputRenderer.this.getBodyText()));
                InputContext context = BooleanInputRenderer.this.getInputContext();
                checkBox.setTargetSlot((MetaSlotKey)context.getMetaObject().getKey());
                return checkBox;
            }

            @Override
            public void applyStyle(HtmlComponent component) {
                super.applyStyle(component);
                HtmlCheckBox checkBox = (HtmlCheckBox)component;
                checkBox.setDisabled(BooleanInputRenderer.this.getDisabled());
            }
        };
    }

    public boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void setBodyText(String bodyText) {
        this.bodyText = bodyText;
    }
}

