/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.utils;

import com.google.common.base.Predicate;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import pt.ist.fenixWebFramework.renderers.exceptions.NoRendererException;
import pt.ist.fenixWebFramework.renderers.utils.ClassHierarchyTable;
import pt.ist.fenixWebFramework.renderers.utils.RendererDescription;

public class RendererRegistry {
    private final ClassHierarchyTable<Map<String, RendererDescription>> renderersTable = new ClassHierarchyTable();

    public void registerRenderer(Class type, String layout, Class renderer, Properties defaultProperties) {
        Map<String, RendererDescription> layoutsTable = this.renderersTable.getUnspecific(type);
        if (layoutsTable == null) {
            this.renderersTable.put(type, new HashMap());
            layoutsTable = this.renderersTable.getUnspecific(type);
        }
        layoutsTable.put(layout, new RendererDescription(renderer, defaultProperties));
    }

    public RendererDescription getRenderDescription(Class objectType, String layout) {
        Map<String, RendererDescription> layoutsTable = this.renderersTable.get(objectType, (Predicate<Map<String, RendererDescription>>)((Predicate)table -> table.get(layout) != null));
        if (layoutsTable == null) {
            throw new NoRendererException(objectType, layout);
        }
        return layoutsTable.get(layout);
    }

    public RendererDescription getExactRenderDescription(Class objectType, String layout) {
        Map<String, RendererDescription> layoutsTable = this.renderersTable.getUnspecific(objectType);
        if (layoutsTable == null) {
            throw new NoRendererException(objectType, layout);
        }
        return layoutsTable.get(layout);
    }
}

