/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletRequest;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.fenixWebFramework.RenderersConfigurationManager;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.state.HiddenSlot;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.Message;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;

public class ViewState
implements IViewState {
    private String id;
    private String layout;
    private Properties properties;
    private transient InputContext context;
    private Map<String, Object> attributes;
    private transient List<Message> messages = new ArrayList<Message>();
    private List<HiddenSlot> hiddenSlots;
    private ViewDestination inputDestination;
    private Map<String, ViewDestination> destinations;
    private ViewDestination currentDestination;
    private User user;
    private transient HtmlComponent component;
    private transient HttpServletRequest request;
    private MetaObject metaObject;
    private boolean visible = true;
    private boolean valid = true;
    private boolean skipUpdate = false;
    private boolean skipValidation = false;
    private boolean updateComponentTree = true;
    private boolean postBack = false;
    private static final String ALGORITHM = "HmacSHA256";
    private static final SecretKeySpec key = new SecretKeySpec(RenderersConfigurationManager.getConfiguration().viewStateSignatureKey().getBytes(StandardCharsets.UTF_8), "HmacSHA256");

    public ViewState() {
    }

    public ViewState(String id) {
        this();
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isPostBack() {
        return this.postBack;
    }

    @Override
    public void cancel() {
        this.id = "";
        this.inputDestination = null;
    }

    @Override
    public boolean isCanceled() {
        return this.id != null && this.id.equals("") && this.inputDestination == null;
    }

    @Override
    public void setPostBack(boolean isPostBack) {
        this.postBack = isPostBack;
    }

    @Override
    public HtmlComponent getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(HtmlComponent component) {
        this.component = component;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setValid(boolean isValid) {
        this.valid = isValid;
    }

    @Override
    public boolean skipUpdate() {
        return this.skipUpdate;
    }

    @Override
    public void setSkipUpdate(boolean skipUpdate) {
        this.skipUpdate = skipUpdate;
    }

    @Override
    public boolean skipValidation() {
        return this.skipValidation;
    }

    @Override
    public void setSkipValidation(boolean skipValidation) {
        this.skipValidation = skipValidation;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setUpdateComponentTree(boolean updateTree) {
        this.updateComponentTree = updateTree;
    }

    @Override
    public boolean getUpdateComponentTree() {
        return this.updateComponentTree;
    }

    @Override
    public void addDestination(String name, ViewDestination destination) {
        if (this.destinations == null) {
            this.destinations = new Hashtable<String, ViewDestination>();
        }
        this.destinations.put(name, destination);
    }

    @Override
    public ViewDestination getDestination(String name) {
        if (this.destinations == null) {
            this.destinations = new Hashtable<String, ViewDestination>();
        }
        return this.destinations.get(name);
    }

    @Override
    public void setInputDestination(ViewDestination destination) {
        this.inputDestination = destination;
    }

    @Override
    public ViewDestination getInputDestination() {
        return this.inputDestination;
    }

    @Override
    public void setCurrentDestination(String name) {
        this.currentDestination = this.getDestination(name);
    }

    @Override
    public void setCurrentDestination(ViewDestination destination) {
        this.currentDestination = destination;
    }

    @Override
    public ViewDestination getCurrentDestination() {
        return this.currentDestination;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public void setMetaObject(MetaObject object) {
        this.metaObject = object;
    }

    @Override
    public MetaObject getMetaObject() {
        return this.metaObject;
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
        if (this.getMetaObject() != null) {
            this.getMetaObject().setUser(user);
        }
    }

    @Override
    public String getLayout() {
        return this.layout;
    }

    @Override
    public void setLayout(String layout) {
        this.layout = layout;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void setLocalAttribute(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Override
    public Object getLocalAttribute(String name) {
        return this.getAttribute(name);
    }

    @Override
    public void removeLocalAttribute(String name) {
        this.removeAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new Hashtable<String, Object>();
        }
        this.attributes.put(name, value);
    }

    @Override
    public Object getAttribute(String name) {
        if (this.attributes == null) {
            this.attributes = new Hashtable<String, Object>();
        }
        return this.attributes.get(name);
    }

    @Override
    public void removeAttribute(String name) {
        if (this.attributes == null) {
            this.attributes = new Hashtable<String, Object>();
        }
        this.attributes.remove(name);
    }

    public static String encodeToBase64(List<IViewState> viewStates) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(new GZIPOutputStream(baos));){
            stream.writeObject(viewStates);
        }
        byte[] bytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(bytes) + "_" + Base64.getEncoder().encodeToString(ViewState.sign(bytes));
    }

    private static byte[] sign(byte[] payload) {
        try {
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(key);
            return mac.doFinal(payload);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Could not sign view state!", e);
        }
    }

    private static void validate(byte[] decodedForm, byte[] signature) {
        byte[] expected = ViewState.sign(decodedForm);
        if (!Arrays.equals(expected, signature)) {
            throw ViewState.invalidViewState();
        }
    }

    private static Object decodeObjectFromBase64(String encodedState) throws IOException, ClassNotFoundException {
        String[] parts = encodedState.split("_", 2);
        if (parts.length != 2) {
            throw ViewState.invalidViewState();
        }
        byte[] decodedForm = Base64.getDecoder().decode(parts[0]);
        ViewState.validate(decodedForm, Base64.getDecoder().decode(parts[1]));
        ObjectInputStream stream = new ObjectInputStream(new GZIPInputStream(new ByteArrayInputStream(decodedForm)));
        return stream.readObject();
    }

    private static RuntimeException invalidViewState() {
        return new IllegalArgumentException("Invalid ViewState provided");
    }

    public static List<IViewState> decodeFromBase64(String encodedState) throws IOException, ClassNotFoundException {
        return (List)ViewState.decodeObjectFromBase64(encodedState);
    }

    @Override
    public void setContext(InputContext context) {
        this.context = context;
    }

    @Override
    public InputContext getContext() {
        return this.context;
    }

    @Override
    public void addHiddenSlot(HiddenSlot slot) {
        if (this.hiddenSlots == null) {
            this.hiddenSlots = new ArrayList<HiddenSlot>();
        }
        this.hiddenSlots.add(slot);
    }

    @Override
    public List<HiddenSlot> getHiddenSlots() {
        if (this.hiddenSlots == null) {
            this.hiddenSlots = new ArrayList<HiddenSlot>();
        }
        return this.hiddenSlots;
    }

    @Override
    public List<Message> setMessages(List<Message> messages) {
        this.ensureMessageList();
        this.messages = messages;
        return this.messages;
    }

    @Override
    public List<Message> getMessages() {
        this.ensureMessageList();
        return this.messages;
    }

    @Override
    public void addMessage(Message message) {
        this.ensureMessageList();
        this.messages.add(message);
    }

    private void ensureMessageList() {
        if (this.messages == null) {
            this.messages = new ArrayList<Message>();
        }
    }
}

