/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableHeader;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlTable
extends HtmlComponent {
    private final List<HtmlTableRow> rows = new ArrayList<HtmlTableRow>();
    private HtmlTableHeader header;
    private String summary;
    private String width;
    private String border;
    private String cellSpacing;
    private String cellPadding;
    private String caption;

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getWidth() {
        return this.width;
    }

    public String getBorder() {
        return this.border;
    }

    public void setBorder(String border) {
        this.border = border;
    }

    public String getCellPadding() {
        return this.cellPadding;
    }

    public void setCellPadding(String cellPadding) {
        this.cellPadding = cellPadding;
    }

    public String getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(String cellSpacing) {
        this.cellSpacing = cellSpacing;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public HtmlTableRow createRow() {
        HtmlTableRow row = new HtmlTableRow();
        this.rows.add(row);
        return row;
    }

    public void removeRow(HtmlTableRow row) {
        this.rows.remove(row);
    }

    public List<HtmlTableRow> getRows() {
        return this.rows;
    }

    public HtmlTableHeader createHeader() {
        this.header = new HtmlTableHeader();
        return this.header;
    }

    public HtmlTableHeader getHeader() {
        return this.header;
    }

    @Override
    public List<HtmlComponent> getChildren() {
        ArrayList<HtmlComponent> children = new ArrayList<HtmlComponent>(super.getChildren());
        if (this.header != null) {
            children.add(this.header);
        }
        children.addAll(this.rows);
        return children;
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        tag.setName("table");
        tag.setAttribute("class", (String)(this.getClasses() == null ? "table" : this.getClasses() + " table"));
        tag.setAttribute("summary", this.summary);
        tag.setAttribute("width", this.width);
        tag.setAttribute("border", this.border);
        tag.setAttribute("cellSpacing", this.cellSpacing);
        tag.setAttribute("cellPadding", this.cellPadding);
        if (this.caption != null) {
            tag.addChild(new HtmlTag("caption", this.caption));
        }
        if (this.header != null) {
            HtmlTag headerTag = this.header.getOwnTag(context);
            tag.addChild(headerTag);
        }
        if (this.rows.size() >= 0) {
            innerTag = new HtmlTag("tbody");
            for (HtmlTableRow row : this.rows) {
                innerTag.addChild(row.getOwnTag(context));
            }
            tag.addChild(innerTag);
        } else {
            innerTag = new HtmlTag("tbody");
            tag.addChild(innerTag);
        }
        if (tag.getChildren().isEmpty()) {
            tag.addChild(new HtmlTag(null));
        }
        return tag;
    }
}

