/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.DateTimeFieldType;
import org.joda.time.Partial;
import org.joda.time.base.AbstractPartial;
import pt.ist.fenixWebFramework.renderers.DateInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.converters.MultipleFormatDateConverter;

public class MultipleFormatTimeInputRenderer
extends DateInputRenderer {
    private boolean minute = false;
    private boolean hour = false;
    private String inputFormat;

    public boolean isHour() {
        return this.hour;
    }

    public void setHour(boolean hour) {
        this.hour = hour;
    }

    public boolean isMinute() {
        return this.minute;
    }

    public void setMinute(boolean minute) {
        this.minute = minute;
    }

    @Override
    public String getFormat() {
        if (this.isFormatSet()) {
            return super.getFormat();
        }
        StringBuilder format = new StringBuilder();
        if (this.isHour()) {
            format.append((format.length() > 0 ? " " : "") + "HH");
        }
        if (this.isMinute()) {
            format.append((format.length() > 0 ? ":" : "") + "mm");
        }
        return format.toString();
    }

    public String getInputFormat() {
        return this.inputFormat == null ? "dd/MM/yyyy" : this.inputFormat;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    @Override
    protected HtmlComponent createTextField(Object object, Class type) {
        Date date = this.convertPartialToDate((AbstractPartial)object);
        return super.createTextField(date, type);
    }

    private Date convertPartialToDate(AbstractPartial partial) {
        if (partial == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        if (this.isHour()) {
            calendar.set(11, partial.get(DateTimeFieldType.hourOfDay()));
        }
        if (this.isMinute()) {
            calendar.set(12, partial.get(DateTimeFieldType.minuteOfHour()));
        }
        return calendar.getTime();
    }

    @Override
    protected Converter getDateConverter(SimpleDateFormat dateFormat) {
        if (this.getInputFormat() != null) {
            dateFormat.applyPattern(this.getInputFormat());
        }
        return new PartialConverter(new MultipleFormatDateConverter(dateFormat));
    }

    public class PartialConverter
    extends Converter {
        private Converter dateConverter;

        public PartialConverter(Converter dateConverter) {
            this.dateConverter = dateConverter;
        }

        @Override
        public Object convert(Class type, Object value) {
            Date date = (Date)this.dateConverter.convert(type, value);
            if (date == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            try {
                return this.convertCalendarToPartial(type, calendar);
            }
            catch (Exception e) {
                throw new ConversionException("fenix.renderers.converter.timeOfDay", (Throwable)e, true, value);
            }
        }

        private Object convertCalendarToPartial(Class type, Calendar calendar) throws Exception {
            if (type.equals(Partial.class)) {
                Partial partial = new Partial();
                if (MultipleFormatTimeInputRenderer.this.isHour()) {
                    partial = partial.with(DateTimeFieldType.hourOfDay(), calendar.get(11));
                }
                if (MultipleFormatTimeInputRenderer.this.isMinute()) {
                    partial = partial.with(DateTimeFieldType.minuteOfHour(), calendar.get(12));
                }
                return partial;
            }
            Method method = type.getMethod("fromCalendarFields", Calendar.class);
            return method.invoke(null, calendar);
        }
    }
}

