/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.core.presentationTier.component;

import java.util.ArrayList;
import java.util.Collection;
import org.fenixedu.bennu.core.presentationTier.component.OrganizationChartRow;

public class OrganizationChart<T>
extends ArrayList<OrganizationChartRow<T>> {
    final int elementRowIndex;
    final int unitsPerPart;

    public OrganizationChart(Collection<T> elements, int unitsPerPart) {
        this.unitsPerPart = unitsPerPart;
        this.addAllElements(elements);
        this.elementRowIndex = -1;
    }

    public OrganizationChart(T element, Collection<T> parents, Collection<T> children, int unitsPerPart) {
        this.unitsPerPart = unitsPerPart;
        if (parents != null && !parents.isEmpty()) {
            this.addAllElements(parents);
        }
        this.elementRowIndex = this.size();
        this.add(new OrganizationChartRow<T>(element, unitsPerPart));
        this.addAllElements(children);
    }

    public void addAllElements(Collection<T> elements) {
        if (elements != null && !elements.isEmpty()) {
            OrganizationChartRow<T> row = null;
            for (T t : elements) {
                if (row == null || row.isFull()) {
                    row = new OrganizationChartRow<T>(t, this.unitsPerPart);
                    this.add(row);
                    continue;
                }
                row.add(t);
            }
        }
    }

    public int getElementRowIndex() {
        return this.elementRowIndex;
    }

    public T getElement() {
        return this.elementRowIndex == -1 ? null : (T)((OrganizationChartRow)this.get(this.elementRowIndex)).iterator().next();
    }

    public int getUnitsPerPart() {
        return this.unitsPerPart;
    }
}

