/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components;

import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlInputComponent;
import pt.ist.fenixWebFramework.renderers.components.tags.HtmlTag;

public class HtmlCheckBox
extends HtmlInputComponent {
    private String text;
    private boolean checked = false;

    public HtmlCheckBox() {
        super("checkbox");
    }

    public HtmlCheckBox(boolean checked) {
        this();
        this.checked = checked;
    }

    public HtmlCheckBox(String text) {
        this();
        this.text = text;
    }

    public HtmlCheckBox(String text, boolean checked) {
        this();
        this.text = text;
        this.checked = checked;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getUserValue() {
        return super.getValue();
    }

    public void setUserValue(String userValue) {
        super.setValue(userValue);
    }

    @Override
    public String getValue() {
        if (this.getUserValue() != null) {
            return this.getUserValue();
        }
        return String.valueOf(this.isChecked());
    }

    @Override
    public void setValue(String value) {
        this.setChecked(value != null);
    }

    @Override
    public HtmlTag getOwnTag(PageContext context) {
        HtmlTag tag = super.getOwnTag(context);
        if (this.isChecked()) {
            tag.setAttribute("checked", "checked");
        }
        if (this.getText() == null) {
            return tag;
        }
        HtmlTag span = new HtmlTag("span");
        span.addChild(tag);
        span.addChild(new HtmlTag(null, this.getText()));
        return span;
    }
}

