/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Collection;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.CollectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class TabularListRenderer
extends CollectionRenderer {
    private String subSchema;
    private String subLayout;
    private String listTitle;
    private boolean listTitleKey = false;
    private String listTitleBundle;
    private Boolean displayHeaders = Boolean.TRUE;

    public String getSubLayout() {
        return this.subLayout;
    }

    public void setSubLayout(String subLayout) {
        this.subLayout = subLayout;
    }

    public String getSubSchema() {
        return this.subSchema;
    }

    @Override
    public boolean getDisplayHeaders() {
        return this.displayHeaders;
    }

    @Override
    public void setDisplayHeaders(boolean displayHeaders) {
        this.displayHeaders = displayHeaders;
    }

    public void setSubSchema(String subSchema) {
        this.subSchema = subSchema;
    }

    public String getListTitle() {
        return this.listTitle;
    }

    public void setListTitle(String listTitle) {
        this.listTitle = listTitle;
    }

    public boolean isListTitleKey() {
        return this.listTitleKey;
    }

    public void setListTitleKey(boolean listTitleKey) {
        this.listTitleKey = listTitleKey;
    }

    public String getListTitleBundle() {
        return this.listTitleBundle;
    }

    public void setListTitleBundle(String listTitleBundle) {
        this.listTitleBundle = listTitleBundle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        List sortedCollection = RenderUtils.sortCollectionWithCriteria((Collection)object, this.getSortBy());
        return new TabularListRendererLayout(sortedCollection);
    }

    public class TabularListRendererLayout
    extends CollectionRenderer.CollectionTabularLayout {
        public TabularListRendererLayout(Collection object) {
            super(TabularListRenderer.this, object);
        }

        @Override
        protected int getNumberOfColumns() {
            return 1 + TabularListRenderer.this.getNumberOfLinks() + (TabularListRenderer.this.isCheckable() ? 1 : 0);
        }

        @Override
        protected boolean hasHeader() {
            return TabularListRenderer.this.displayHeaders.booleanValue() ? TabularListRenderer.this.getListTitle() != null : false;
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            if (columnIndex == (TabularListRenderer.this.isCheckable() ? 1 : 0)) {
                String description = TabularListRenderer.this.isListTitleKey() ? RenderUtils.getResourceString(TabularListRenderer.this.getListTitleBundle(), TabularListRenderer.this.getListTitle()) : TabularListRenderer.this.getListTitle();
                return new HtmlText(description);
            }
            return new HtmlText();
        }

        @Override
        protected HtmlComponent generateObjectComponent(int columnIndex, MetaObject object) {
            Schema schema = RenderKit.getInstance().findSchema(TabularListRenderer.this.getSubSchema());
            String layout = TabularListRenderer.this.getSubLayout();
            return TabularListRenderer.this.renderValue(object.getObject(), schema, layout);
        }
    }
}

