/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.validators;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Locale;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixWebFramework.rendererExtensions.validators.LocalizedStringValidator;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;

public class RequiredLocalizedStringValidator
extends LocalizedStringValidator {
    public RequiredLocalizedStringValidator() {
        this.setMessage("renderers.validator.language.required");
    }

    public RequiredLocalizedStringValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setMessage("renderers.validator.language.required");
    }

    @Override
    public void performValidation() {
        super.performValidation();
        if (!this.isValid()) {
            return;
        }
        HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getComponent();
        if (Strings.isNullOrEmpty((String)component.getValue())) {
            this.setValid(false);
            return;
        }
        JsonElement json = new JsonParser().parse(component.getValue());
        LocalizedString string = LocalizedString.fromJson((JsonElement)json);
        for (Locale locale : string.getLocales()) {
            if (string.getContent(locale).isEmpty()) continue;
            this.setValid(true);
            return;
        }
        this.setValid(false);
    }
}

