/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlForm;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.HiddenSlot;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ViewState;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixWebFramework.renderers.taglib.BaseRenderObjectTag;
import pt.ist.fenixWebFramework.renderers.taglib.ContextTag;
import pt.ist.fenixWebFramework.renderers.taglib.FormTag;
import pt.ist.fenixWebFramework.renderers.taglib.ValidatorContainerTag;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.RequiredValidator;
import pt.ist.fenixWebFramework.renderers.validators.ValidatorProperties;

public class EditObjectTag
extends BaseRenderObjectTag
implements ValidatorContainerTag {
    private static final Collection<Class<?>> formTagTypes = new ConcurrentLinkedQueue();
    private boolean nested = false;
    private boolean visible = true;
    private String action;
    private String slot;
    private Map<String, Properties> validators = new HashMap<String, Properties>();
    private String converter;
    private List<HiddenSlot> hiddenSlots = new ArrayList<HiddenSlot>();
    private Properties validatorProperties = new Properties();

    public static void registerFormTagType(Class<?> type) {
        formTagTypes.add(type);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isNested() {
        return this.nested;
    }

    public void setNested(boolean nested) {
        this.nested = nested;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getSlot() {
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    @Override
    public void addValidator(String name) {
        this.validators.put(name, new Properties());
    }

    @Override
    public void release() {
        super.release();
        this.nested = false;
        this.visible = true;
        this.action = null;
        this.slot = null;
        this.converter = null;
        this.validators = new HashMap<String, Properties>();
        this.hiddenSlots = new ArrayList<HiddenSlot>();
        this.validatorProperties = new Properties();
    }

    protected boolean isPostBack() {
        return this.getViewState() != null;
    }

    @Override
    protected Object getTargetObject() throws JspException {
        if (!this.isPostBack()) {
            return super.getTargetObject();
        }
        IViewState viewState = this.getViewState();
        return viewState.getMetaObject().getObject();
    }

    @Override
    protected PresentationContext createPresentationContext(Object object, String layout, Schema schema, Properties properties) {
        IViewState viewState = this.createViewState(object);
        if (viewState.getContext() != null) {
            return viewState.getContext();
        }
        InputContext context = new InputContext();
        context.setSchema(schema);
        context.setLayout(layout);
        context.setProperties(properties);
        viewState.setContext(context);
        context.setViewState(viewState);
        return context;
    }

    @Override
    protected HtmlComponent renderObject(PresentationContext context, Object object) throws JspException {
        if (!this.isVisible()) {
            return null;
        }
        if (this.isPostBack()) {
            return this.retrieveComponent();
        }
        if (this.getSlot() == null) {
            if (this.getType() == null) {
                return RenderKit.getInstance().render(context, object);
            }
            try {
                Class<?> type = Class.forName(this.getType());
                return RenderKit.getInstance().render(context, object, type);
            }
            catch (ClassNotFoundException e) {
                throw new JspException("could not get class named " + this.getType(), (Throwable)e);
            }
        }
        MetaObject metaObject = context.getMetaObject();
        return RenderKit.getInstance().render(context, metaObject.getObject(), metaObject.getType());
    }

    @Override
    protected boolean isNullAccepted() {
        return this.getSlot() != null;
    }

    protected HtmlComponent retrieveComponent() {
        return this.getViewState().getComponent();
    }

    @Override
    protected void drawComponent(PresentationContext context, HtmlComponent component) throws JspException, IOException {
        HtmlComponent componentToDraw;
        InputContext inputContext = (InputContext)context;
        IViewState viewState = inputContext.getViewState();
        ArrayList<HtmlHiddenField> hiddenFields = new ArrayList<HtmlHiddenField>();
        for (HiddenSlot slot : this.hiddenSlots) {
            if (this.getSlot() != null) {
                MetaSlot metaSlot = (MetaSlot)viewState.getMetaObject();
                slot.setKey(metaSlot.getKey());
            }
            for (String value : slot.getValues()) {
                HtmlHiddenField field = new HtmlHiddenField(slot.getName(), value);
                field.setTargetSlot(slot.getKey());
                hiddenFields.add(field);
            }
            viewState.addHiddenSlot(slot);
        }
        if (this.hasParentForm()) {
            this.addViewStateToParentForm(viewState);
        } else {
            HtmlHiddenField htmlViewStateField = new HtmlHiddenField(LifeCycleConstants.VIEWSTATE_PARAM_NAME, ViewState.encodeToBase64(Collections.singletonList(viewState)));
            hiddenFields.add(htmlViewStateField);
        }
        if (this.isNested() || this.hasFormParent()) {
            if (hiddenFields != null && !hiddenFields.isEmpty()) {
                HtmlBlockContainer container = new HtmlBlockContainer();
                container.setClasses("dinline");
                for (HtmlHiddenField field : hiddenFields) {
                    container.addChild(field);
                }
                if (component != null) {
                    container.addChild(component);
                }
                componentToDraw = container;
            } else {
                componentToDraw = component == null ? new HtmlText() : component;
            }
        } else {
            HtmlForm form = inputContext.getForm();
            form.setId(this.getId());
            form.setAction(this.getActionPath());
            form.setMethod("post");
            form.setBody(component);
            for (HtmlHiddenField field : hiddenFields) {
                form.addHiddenField(field);
            }
            componentToDraw = form;
        }
        componentToDraw.draw(this.pageContext);
        if (inputContext.isToolkitRequired() && this.pageContext.findAttribute("org.fenixedu.bennu.renderers.TOOLKIT") == null) {
            this.pageContext.getOut().write("<script type=\"text/javascript\" src=\"" + this.pageContext.getRequest().getServletContext().getContextPath() + "/bennu-toolkit/js/toolkit.js\" defer></script>");
            this.pageContext.getOut().write("<link href=\"" + this.pageContext.getRequest().getServletContext().getContextPath() + "/bennu-toolkit/css/toolkit.css\" rel=\"stylesheet\">");
            this.pageContext.setAttribute("org.fenixedu.bennu.renderers.TOOLKIT", (Object)Boolean.TRUE);
        }
    }

    private boolean hasFormParent() {
        for (Class<?> type : formTagTypes) {
            if (EditObjectTag.findAncestorWithClass((Tag)this, type) == null) continue;
            return true;
        }
        return false;
    }

    protected void addViewStateToParentForm(IViewState viewState) {
        ContextTag parent = (ContextTag)EditObjectTag.findAncestorWithClass((Tag)this, ContextTag.class);
        parent.addViewState(viewState);
    }

    protected boolean hasParentForm() {
        return EditObjectTag.findAncestorWithClass((Tag)this, ContextTag.class) != null;
    }

    protected String getActionPath() {
        HttpServletResponse response = (HttpServletResponse)this.pageContext.getResponse();
        String action = this.getAction();
        if (action == null) {
            action = this.getCurrentPath();
        }
        String actionMappingURL = RenderUtils.getActionMappingURL(action, this.pageContext);
        return response.encodeURL(actionMappingURL);
    }

    protected IViewState getViewState() {
        List viewStates = (List)this.pageContext.findAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        if (viewStates == null) {
            return null;
        }
        for (IViewState viewState : viewStates) {
            MetaSlot metaSlot;
            if (this.getId() != null ? !this.getId().equals(viewState.getId()) : viewState.getId() != null || !this.getInputDestination().equals(viewState.getInputDestination())) continue;
            if (this.getSlot() != null && (!(viewState.getMetaObject() instanceof MetaSlot) || !(metaSlot = (MetaSlot)viewState.getMetaObject()).getName().equals(this.getSlot()))) continue;
            return viewState;
        }
        return null;
    }

    protected IViewState createViewState(Object targetObject) {
        IViewState viewState;
        if (this.isPostBack()) {
            viewState = this.getViewState();
            viewState.setVisible(this.isVisible());
            MetaObject metaObject = viewState.getMetaObject();
            if (metaObject instanceof MetaSlot) {
                this.updateHiddenSlots(((MetaSlot)metaObject).getMetaObject());
            } else {
                this.updateHiddenSlots(metaObject);
            }
        } else {
            viewState = new ViewState(this.getId());
            viewState.setVisible(this.isVisible());
            viewState.setLayout(this.getLayout());
            viewState.setProperties(this.getRenderProperties());
            viewState.setRequest((HttpServletRequest)this.pageContext.getRequest());
            Schema schema = this.getComputedSchema(targetObject);
            MetaObject metaObject = this.createMetaObject(targetObject, schema);
            viewState.setMetaObject(metaObject);
            this.setViewStateDestinations(viewState);
        }
        return viewState;
    }

    protected Schema getComputedSchema(Object targetObject) {
        if (this.getSlot() == null && this.isVisible()) {
            return this.getRealSchema();
        }
        Schema schema = new Schema(null, targetObject.getClass());
        if (this.isVisible()) {
            SchemaSlotDescription slotDescription = new SchemaSlotDescription(this.getSlot());
            slotDescription.setValidators(this.getValidatorsClass());
            slotDescription.setConverter(this.getConverterClass());
            schema.addSlotDescription(slotDescription);
        }
        return schema;
    }

    protected Properties getValidatorProperties() {
        return this.validatorProperties;
    }

    protected Class<Converter> getConverterClass() {
        String converterName = this.getConverter();
        if (converterName == null) {
            return null;
        }
        try {
            return Class.forName(converterName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("specified converter does not exist: " + converterName, e);
        }
    }

    protected List<ValidatorProperties> getValidatorsClass() {
        ArrayList<ValidatorProperties> res = new ArrayList<ValidatorProperties>();
        Map<String, Properties> validatorsMap = this.getValidators();
        for (Map.Entry<String, Properties> entry : this.getValidators().entrySet()) {
            try {
                Class<HtmlValidator> validatorClass = Class.forName(entry.getKey());
                res.add(new ValidatorProperties(validatorClass, entry.getValue()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("specified validator does not exist: " + entry.getKey(), e);
            }
        }
        return res;
    }

    private void updateHiddenSlots(MetaObject metaObject) {
        for (HiddenSlot hiddenSlot : this.hiddenSlots) {
            for (MetaSlot slot : metaObject.getHiddenSlots()) {
                if (!slot.getName().equals(hiddenSlot.getName())) continue;
                hiddenSlot.setKey(slot.getKey());
            }
        }
    }

    protected MetaObject createMetaObject(Object targetObject, Schema schema) {
        MetaObject metaObject = this.getNewMetaObject(targetObject, schema);
        for (HiddenSlot slot : this.hiddenSlots) {
            MetaSlot metaSlot = metaObject.getSlot(slot.getName());
            if (metaSlot == null) {
                SchemaSlotDescription slotDescription = new SchemaSlotDescription(slot.getName());
                slotDescription.setConverter(slot.getConverter());
                metaSlot = MetaObjectFactory.createSlot(metaObject, slotDescription);
                metaObject.addHiddenSlot(metaSlot);
            } else {
                metaSlot.setConverter(slot.getConverter());
            }
            slot.setKey(metaSlot.getKey());
        }
        if (this.getSlot() == null) {
            return metaObject;
        }
        MetaSlot metaSlot = metaObject.getSlot(this.getSlot());
        if (metaSlot != null) {
            return metaSlot;
        }
        throw new RuntimeException("specified slot '" + this.getSlot() + "' does not exist in object " + targetObject);
    }

    protected MetaObject getNewMetaObject(Object targetObject, Schema schema) {
        return MetaObjectFactory.createObject(targetObject, schema);
    }

    public void addHiddenSlot(String slot, boolean multiple, String value, Class<Converter> converter) {
        HiddenSlot hiddenSlot;
        if (this.getSlot() != null) {
            this.setVisible(false);
        }
        if ((hiddenSlot = this.getHiddenSlot(slot)) == null) {
            if (this.getSlot() != null && this.hiddenSlots.size() > 0) {
                throw new RuntimeException("can only pass hidden values to slot '" + this.getSlot() + "'");
            }
            hiddenSlot = new HiddenSlot(slot, value, converter);
            this.hiddenSlots.add(hiddenSlot);
        } else {
            hiddenSlot.addValue(value);
        }
        hiddenSlot.setConverter(converter);
        hiddenSlot.setMultiple(hiddenSlot.isMultiple() || multiple);
    }

    public HiddenSlot getHiddenSlot(String name) {
        for (HiddenSlot slot : this.hiddenSlots) {
            if (!slot.getName().equals(name)) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void addValidatorProperty(String validator, String name, String value) {
        this.validators.get(validator).setProperty(name, value);
    }

    protected Map<String, Properties> getValidators() {
        return this.validators;
    }

    protected void setValidators(Map<String, Properties> validators) {
        this.validators = validators;
    }

    public void setValidator(String validatorName) {
        this.validators.clear();
        this.validators.put(validatorName, new Properties());
    }

    public boolean isRequired() {
        return this.validators.containsKey(RequiredValidator.class.getName());
    }

    public void setRequired(boolean required) {
        if (required) {
            this.validators.put(RequiredValidator.class.getName(), new Properties());
        }
    }

    static {
        formTagTypes.add(FormTag.class);
    }
}

