/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public abstract class Renderer {
    private PresentationContext context;
    private String classes;
    private String style;
    private String title;

    public PresentationContext getContext() {
        return this.context;
    }

    public void setContext(PresentationContext context) {
        this.context = context;
    }

    public HttpServletRequest getRequest() {
        return this.context.getViewState().getRequest();
    }

    public void setClasses(String classes) {
        this.classes = classes;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getClasses() {
        return this.classes;
    }

    public String getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    public HtmlComponent render(Object object, Class type) {
        Layout layout = this.getLayout(object, type);
        if (layout != null) {
            this.setLayoutProperties(layout);
        }
        HtmlComponent component = this.renderComponent(layout, object, type);
        return component;
    }

    protected abstract Layout getLayout(Object var1, Class var2);

    protected HtmlComponent renderComponent(Layout layout, Object object, Class type) {
        return layout.createLayout(object, type);
    }

    protected void setLayoutProperties(Layout layout) {
        String[] names = layout.getAndVerifyPropertyNames();
        Properties layoutProperties = new Properties();
        for (String name : names) {
            try {
                if (PropertyUtils.getProperty((Object)this, (String)name) == null) continue;
                layoutProperties.setProperty(name, BeanUtils.getProperty((Object)this, (String)name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RenderUtils.setProperties(layout, layoutProperties);
    }

    protected HtmlComponent renderValue(Object value, Class type, Schema schema, String layout, Properties properties) {
        MetaObject metaObject = MetaObjectFactory.createObject(value, schema);
        PresentationContext newContext = this.getContext().createSubContext(metaObject);
        newContext.setSchema(schema == null ? null : schema);
        newContext.setLayout(layout);
        newContext.setProperties(properties);
        RenderKit kit = RenderKit.getInstance();
        return kit.render(newContext, value, type);
    }

    protected HtmlComponent renderValue(Object value, Schema schema, String layout) {
        return this.renderValue(value, value.getClass(), schema, layout, new Properties());
    }

    protected HtmlComponent renderValue(Object value, Class type, Schema schema, String layout) {
        return this.renderValue(value, type, schema, layout, new Properties());
    }

    protected HtmlComponent renderSlot(MetaSlot slot) {
        PresentationContext newContext = this.createPresentationContext(slot);
        Object value = slot.getObject();
        Class type = slot.getType();
        RenderKit kit = RenderKit.getInstance();
        return kit.render(newContext, value, type);
    }

    protected HtmlComponent renderSlot(Renderer renderer, MetaSlot slot) {
        PresentationContext newContext = this.createPresentationContext(slot);
        Object value = slot.getObject();
        Class type = slot.getType();
        RenderKit kit = RenderKit.getInstance();
        return kit.renderUsing(renderer, newContext, value, type);
    }

    protected PresentationContext createPresentationContext(MetaSlot slot) {
        MetaObject metaObject = MetaObjectFactory.createObject(slot.getObject(), slot.getSchema());
        PresentationContext newContext = this.getContext().createSubContext(metaObject);
        newContext.setSchema(slot.getSchema() != null ? slot.getSchema() : null);
        newContext.setLayout(slot.getLayout());
        newContext.setProperties(slot.getProperties());
        return newContext;
    }
}

