/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;

public class ConditionalFormatRenderer
extends OutputRenderer {
    private final Map<String, ConditionalFormat> conditionalFormats = new Hashtable<String, ConditionalFormat>();

    public ConditionalFormat getConditionalFormat(String name) {
        ConditionalFormat format = this.conditionalFormats.get(name);
        if (format == null) {
            format = new ConditionalFormat();
            this.conditionalFormats.put(name, format);
        }
        return format;
    }

    public void setFormat(String name, String format) {
        this.getConditionalFormat(name).setFormat(format);
    }

    public void setUseFormatIf(String name, String useFormatIf) {
        this.getConditionalFormat(name).setUseFormatIf(useFormatIf);
    }

    public void setUseFormatIfNot(String name, String useFormatIfNot) {
        this.getConditionalFormat(name).setUseFormatIfNot(useFormatIfNot);
    }

    public void setOrder(String name, String order) {
        this.getConditionalFormat(name).setOrder(Integer.valueOf(order));
    }

    public void setEscaped(String name, String escaped) {
        this.getConditionalFormat(name).setEscaped(Boolean.valueOf(escaped));
    }

    public void setUseParent(String name, String useParent) {
        this.getConditionalFormat(name).setUseParent(Boolean.valueOf(useParent));
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new FormatLayout();
    }

    public static class ConditionalFormat {
        public static final Comparator<ConditionalFormat> COMPARATOR_BY_ORDER = new Comparator<ConditionalFormat>(){

            @Override
            public int compare(ConditionalFormat o1, ConditionalFormat o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        };
        private String format;
        private String useFormatIf;
        private String useFormatIfNot;
        private Integer order = 0;
        private Boolean escaped = Boolean.FALSE;
        private Boolean useParent = Boolean.FALSE;

        public void setFormat(String format) {
            this.format = format;
        }

        public String getFormat() {
            return this.format;
        }

        public void setUseFormatIf(String useFormatIf) {
            this.useFormatIf = useFormatIf;
        }

        public String getUseFormatIf() {
            return this.useFormatIf;
        }

        public void setUseFormatIfNot(String useFormatIfNot) {
            this.useFormatIfNot = useFormatIfNot;
        }

        public String getUseFormatIfNot() {
            return this.useFormatIfNot;
        }

        public void setOrder(Integer order) {
            this.order = order;
        }

        public Integer getOrder() {
            return this.order;
        }

        public void setEscaped(Boolean escaped) {
            this.escaped = escaped;
        }

        public Boolean isEscaped() {
            return this.escaped;
        }

        public void setUseParent(Boolean useParent) {
            this.useParent = useParent;
        }

        public Boolean isUseParent() {
            return this.useParent;
        }
    }

    private class FormatLayout
    extends Layout {
        private FormatLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            if (object == null) {
                return new HtmlText();
            }
            TreeSet<ConditionalFormat> orderedFormats = new TreeSet<ConditionalFormat>(ConditionalFormat.COMPARATOR_BY_ORDER);
            orderedFormats.addAll(ConditionalFormatRenderer.this.conditionalFormats.values());
            for (ConditionalFormat format : orderedFormats) {
                Object usedObject = this.getTargetObject(object, format);
                Boolean useFormatIfResult = null;
                Boolean useFormatIfNotResult = null;
                try {
                    if (format.getUseFormatIf() != null) {
                        useFormatIfResult = (Boolean)RendererPropertyUtils.getProperty(usedObject, format.getUseFormatIf(), false);
                    }
                    if (format.getUseFormatIfNot() != null) {
                        useFormatIfNotResult = (Boolean)RendererPropertyUtils.getProperty(usedObject, format.getUseFormatIfNot(), false);
                    }
                }
                catch (ClassCastException e) {
                    e.printStackTrace();
                }
                if ((useFormatIfResult != null || useFormatIfNotResult != null) && (useFormatIfResult != null && !useFormatIfResult.booleanValue() || useFormatIfNotResult != null && useFormatIfNotResult.booleanValue())) continue;
                String formatedObject = RenderUtils.getFormattedProperties(format.getFormat(), usedObject);
                return new HtmlText(formatedObject, format.isEscaped());
            }
            return new HtmlText(RenderUtils.getFormattedProperties(null, object));
        }

        private Object getTargetObject(Object object, ConditionalFormat format) {
            if (format.isUseParent().booleanValue()) {
                PresentationContext parentContext = ConditionalFormatRenderer.this.getContext().getParentContext();
                return parentContext == null ? null : parentContext.getMetaObject().getObject();
            }
            return object;
        }
    }
}

