/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixWebFramework.rendererExtensions.LocalizedStringRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class ShortLocalizedStringRenderer
extends LocalizedStringRenderer {
    private Integer length;
    private boolean tooltipShown = true;

    public boolean isTooltipShown() {
        return this.tooltipShown;
    }

    public void setTooltipShown(boolean tooltipShown) {
        this.tooltipShown = tooltipShown;
    }

    @Override
    public Integer getLength() {
        return this.length;
    }

    @Override
    public void setLength(Integer length) {
        this.length = length;
    }

    @Override
    protected String getRenderedText(LocalizedString mlString) {
        String content = super.getRenderedText(mlString);
        if (content != null && this.getLength() != null && content.length() > this.getLength()) {
            return content.substring(0, this.getLength()) + "...";
        }
        return content;
    }

    @Override
    protected HtmlComponent renderComponent(Layout layout, Object object, Class type) {
        HtmlComponent component = super.renderComponent(layout, object, type);
        LocalizedString mlString = this.getLocalized(object);
        String previous = super.getRenderedText(mlString);
        String current = this.getRenderedText(mlString);
        if (this.isTooltipShown() && !String.valueOf(previous).equals(String.valueOf(current))) {
            component.setTitle(HtmlText.escape(previous));
        }
        return component;
    }
}

