/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.core.presentationTier.tagLib.commons;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.fenixedu.bennu.core.presentationTier.component.OrganizationChart;
import org.fenixedu.bennu.core.presentationTier.component.OrganizationChartRow;

public class OrganizationChartTag
extends BodyTagSupport {
    private static final String VERTICAL_LINE_HEIGHT = "height: 106px;";
    private static final String VERTICAL_LINE_WIDTH = "width: 5px;";
    private static final String VERTICAL_LINE_STYLE = "height: 106px; width: 5px;";
    private static final String HEIGHT_CONNECTOR = "height: 20px;";
    private static final String BORDER_TOP = "border-top: 1px solid #000;";
    private static final String BORDER_RIGHT = "border-right: 1px solid #000;";
    private static final String BORDER_TOP_RIGHT = "border-top: 1px solid #000; border-right: 1px solid #000;";
    private static final String TABLE_OPEN_PREFIX = "<table style=\"padding: 0px; margin: 0px;\" cellpadding=\"0\" cellspacing=\"0\"";
    private static final String TABLE_OPEN_SUFFIX = ">";
    private static final String TABLE_OPEN = "<table style=\"padding: 0px; margin: 0px;\" cellpadding=\"0\" cellspacing=\"0\">";
    private static final String TABLE_CLOSE = "</table>";
    private static final String ROW_OPEN = "\t<tr>";
    private static final String ROW_CLOSE = "</tr>";
    private static final String COLUMN_OPEN = "<td>";
    private static final String COLUMN_CLOSE = "</td>";
    private String name;
    private String id;
    private String type;
    private OrganizationChart<OrganizationChartRow<Object>> organizationChart;
    private int rowIndex = 0;
    private int columnIndex = 0;
    private StringBuilder stringBuilder = null;

    private void print(String string) throws JspException {
        this.stringBuilder.append(string);
    }

    private void printBodyContent() throws JspException {
        this.print(this.bodyContent.getString());
        try {
            this.bodyContent.clear();
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    private void printToJsp() throws JspException {
        this.printToJsp(this.stringBuilder.toString());
    }

    private void printToJsp(String string) throws JspException {
        try {
            this.pageContext.getOut().print(string);
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
    }

    public int doStartTag() throws JspException {
        super.doStartTag();
        this.stringBuilder = new StringBuilder();
        this.organizationChart = (OrganizationChart)this.pageContext.getAttribute(this.name, 2);
        this.print(TABLE_OPEN);
        return !this.organizationChart.isEmpty() && this.rowIndex < this.organizationChart.size() ? 2 : 0;
    }

    public int doEndTag() throws JspException {
        this.print(TABLE_CLOSE);
        this.printToJsp();
        this.name = null;
        this.id = null;
        this.type = null;
        this.organizationChart = null;
        this.rowIndex = 0;
        this.columnIndex = 0;
        super.doEndTag();
        return 6;
    }

    public void doInitBody() throws JspException {
        super.doInitBody();
        if (this.columnIndex == 0) {
            this.print(ROW_OPEN);
            this.printRowBuffer();
        }
        OrganizationChartRow row = (OrganizationChartRow)this.organizationChart.get(this.rowIndex);
        int rowSize = row.size();
        int elementRowIndex = this.organizationChart.getElementRowIndex();
        if (this.rowIndex > elementRowIndex) {
            if (elementRowIndex >= 0 && this.rowIndex < this.organizationChart.size() - 1) {
                if (this.columnIndex == row.getUnitsPerPart()) {
                    this.printVerticalLine();
                }
            } else if (rowSize == 4 && this.columnIndex == 2 || rowSize == 6 && this.columnIndex == 3 || rowSize == 2 && this.columnIndex == 1) {
                this.printColumn(null, null, null);
            }
        }
        int colspan = rowSize == 1 || rowSize == 3 && this.columnIndex == 1 || rowSize == 5 && this.columnIndex == 2 ? 3 : 1;
        this.printColumnOpen(colspan, null, null, null);
        Object object = row.get(this.columnIndex);
        this.pageContext.removeAttribute(this.id);
        this.pageContext.setAttribute(this.id, object);
    }

    public int doAfterBody() throws JspException {
        super.doAfterBody();
        this.printBox();
        this.print(COLUMN_CLOSE);
        OrganizationChartRow row = (OrganizationChartRow)this.organizationChart.get(this.rowIndex);
        if (++this.columnIndex == row.size()) {
            this.printRowBuffer();
            this.print(ROW_CLOSE);
            this.columnIndex = 0;
            ++this.rowIndex;
        }
        if (this.rowIndex == this.organizationChart.size()) {
            return 0;
        }
        this.doInitBody();
        return 2;
    }

    public void release() {
        this.organizationChart = null;
        super.release();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    private void printRowBuffer() throws JspException {
        int rowSize = ((OrganizationChartRow)this.organizationChart.get(this.rowIndex)).size();
        int padSize = rowSize == 3 || rowSize == 4 ? 1 : (rowSize < 3 ? 2 : 0);
        for (int i = 0; i < padSize; ++i) {
            this.print(COLUMN_OPEN);
            this.print(COLUMN_CLOSE);
        }
    }

    private void printVerticalLine() throws JspException {
        this.print(COLUMN_OPEN);
        this.print(TABLE_OPEN);
        this.printRowOpen(VERTICAL_LINE_STYLE);
        this.printColumn(null, BORDER_TOP_RIGHT, null);
        this.printColumn(null, BORDER_TOP, null);
        this.print(ROW_CLOSE);
        this.print(TABLE_CLOSE);
        this.print(COLUMN_CLOSE);
    }

    private void printAttribute(String name, String value) throws JspException {
        this.print(" ");
        this.print(name);
        this.print("=\"");
        this.print(value);
        this.print("\"");
    }

    private void printTableOpen(String width) throws JspException {
        this.print(TABLE_OPEN_PREFIX);
        if (width != null) {
            this.printAttribute("width", width);
        }
        this.print(TABLE_OPEN_SUFFIX);
    }

    private void printRowOpen(String style) throws JspException {
        this.print("<tr");
        if (style != null) {
            this.printAttribute("style", style);
        }
        this.print(TABLE_OPEN_SUFFIX);
    }

    private void printColumnOpen(int colSpan, String width, String style, String align) throws JspException {
        this.print("<td");
        if (colSpan > 1) {
            this.printAttribute("colspan", Integer.toString(colSpan));
        }
        if (width != null) {
            this.printAttribute("width", width);
        }
        if (style != null) {
            this.printAttribute("style", style);
        }
        if (align != null) {
            this.printAttribute("align", align);
        }
        this.print(TABLE_OPEN_SUFFIX);
    }

    private void printColumn(String width, String style, String align) throws JspException {
        this.printColumnOpen(1, width, style, align);
        this.print(COLUMN_CLOSE);
    }

    private String getBoxUpperLeftStyle() {
        return this.organizationChart.getElementRowIndex() == -1 || this.rowIndex == 0 ? null : (this.columnIndex == 0 ? BORDER_RIGHT : BORDER_TOP_RIGHT);
    }

    private String getBoxUpperRightStyle() {
        int rowSize = ((OrganizationChartRow)this.organizationChart.get(this.rowIndex)).size();
        return this.organizationChart.getElementRowIndex() == -1 || this.rowIndex == 0 ? null : (this.columnIndex == rowSize - 1 ? null : BORDER_TOP);
    }

    private String getBoxLowerLeftStyle() {
        return this.organizationChart.getElementRowIndex() > -1 && this.rowIndex <= this.organizationChart.getElementRowIndex() && this.rowIndex < this.organizationChart.size() - 1 ? BORDER_RIGHT : null;
    }

    private String getBoxLowerRightStyle() {
        return null;
    }

    private void printBox() throws JspException {
        this.printTableOpen("100%");
        this.printRowOpen(HEIGHT_CONNECTOR);
        this.printColumn("50%", this.getBoxUpperLeftStyle(), null);
        this.printColumn("50%", this.getBoxUpperRightStyle(), null);
        this.print(ROW_CLOSE);
        this.print(ROW_OPEN);
        this.printColumnOpen(2, null, null, "center");
        this.printBodyContent();
        this.print(COLUMN_CLOSE);
        this.print(ROW_CLOSE);
        this.printRowOpen(HEIGHT_CONNECTOR);
        this.printColumn("50%", this.getBoxLowerLeftStyle(), null);
        this.printColumn("50%", this.getBoxLowerRightStyle(), null);
        this.print(ROW_CLOSE);
        this.print(TABLE_CLOSE);
    }
}

