/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.bennu.core.presentationTier.renderers.autoCompleteProvider;

import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.presentationTier.renderers.autoCompleteProvider.AutoCompleteProvider;
import org.fenixedu.commons.StringNormalizer;

public class UserAutoComplete
implements AutoCompleteProvider<User> {
    @Override
    public Collection<User> getSearchResults(Map<String, String> argsMap, String value, int maxCount) {
        Stream users = Bennu.getInstance().getUserSet().stream();
        String trimmedValue = value.trim();
        String[] input = StringNormalizer.normalize((String)trimmedValue).split(" ");
        return users.filter(u -> this.match(input, (User)u)).collect(Collectors.toSet());
    }

    private boolean match(String[] values, User u) {
        return values.length == 1 && this.hasMatch(values, StringNormalizer.normalize((String)u.getUsername())) || u.getProfile() != null && this.hasMatch(values, StringNormalizer.normalize((String)u.getProfile().getFullName()).toLowerCase());
    }

    private boolean hasMatch(String[] input, String string) {
        for (String namePart : input) {
            if (string.indexOf(namePart) != -1) continue;
            return false;
        }
        return true;
    }
}

