/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.layouts;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableHeader;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public abstract class TabularLayout
extends Layout {
    protected static Logger logger = LoggerFactory.getLogger(TabularLayout.class);
    private String caption;
    private String summary;
    private String rowClasses;
    private String columnClasses;
    private String headerClasses;
    private HtmlTable table;

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getHeaderClasses() {
        return this.headerClasses;
    }

    public void setHeaderClasses(String headerClasses) {
        this.headerClasses = headerClasses;
    }

    public String getRowClasses() {
        return this.rowClasses;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public HtmlTable getTable() {
        return this.table;
    }

    public void setTable(HtmlTable table) {
        this.table = table;
    }

    @Override
    public String[] getPropertyNames() {
        return this.mergePropertyNames(super.getPropertyNames(), new String[]{"caption", "summary", "rowClasses", "columnClasses", "headerClasses"});
    }

    @Override
    public HtmlComponent createComponent(Object object, Class type) {
        HtmlTable table = new HtmlTable();
        this.setTable(table);
        int rowNumber = this.getNumberOfRows();
        int columnNumber = this.getNumberOfColumns();
        if (this.hasHeader()) {
            HtmlTableHeader header = table.createHeader();
            HtmlTableRow firstRow = header.createRow();
            HtmlTableRow secondRow = null;
            if (this.hasHeaderGroups()) {
                secondRow = header.createRow();
            }
            String lastGroup = null;
            HtmlTableCell lastGroupCell = null;
            for (int columnIndex = 0; columnIndex < columnNumber; ++columnIndex) {
                HtmlTableCell cell;
                String group = this.getHeaderGroup(columnIndex);
                if (this.hasHeaderGroups() && group != null) {
                    if (lastGroup != null && lastGroup.equals(group)) {
                        if (lastGroupCell.getColspan() == null) {
                            lastGroupCell.setColspan(2);
                        } else {
                            lastGroupCell.setColspan(lastGroupCell.getColspan() + 1);
                        }
                    } else {
                        cell = firstRow.createCell();
                        cell.setBody(new HtmlText(group));
                        lastGroup = group;
                        lastGroupCell = cell;
                    }
                    cell = secondRow.createCell();
                    cell.setBody(this.getHeaderComponent(columnIndex));
                    continue;
                }
                lastGroup = null;
                lastGroupCell = null;
                cell = firstRow.createCell();
                cell.setBody(this.getHeaderComponent(columnIndex));
                if (!this.hasHeaderGroups()) continue;
                cell.setRowspan(2);
            }
        }
        for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
            HtmlTableRow row = table.createRow();
            try {
                for (int columnIndex = 0; columnIndex < columnNumber; ++columnIndex) {
                    HtmlTableCell cell = row.createCell();
                    if (this.isHeader(rowIndex, columnIndex)) {
                        cell.setType(HtmlTableCell.CellType.HEADER);
                    }
                    this.costumizeCell(cell, rowIndex, columnIndex);
                    if (cell.getColspan() != null) {
                        columnIndex += cell.getColspan() - 1;
                    }
                    if (this.getCellClasses(rowIndex, columnIndex) != null) {
                        cell.addClass(this.getCellClasses(rowIndex, columnIndex));
                    }
                    cell.setBody(this.getComponent(rowIndex, columnIndex));
                }
                continue;
            }
            catch (Exception e) {
                logger.warn("while generating table row " + rowIndex + " catched exception ", (Throwable)e);
                table.removeRow(row);
            }
        }
        return table;
    }

    protected boolean hasHeader() {
        return false;
    }

    protected boolean hasHeaderGroups() {
        return false;
    }

    protected abstract HtmlComponent getHeaderComponent(int var1);

    protected String getHeaderGroup(int columnIndex) {
        return null;
    }

    protected void costumizeCell(HtmlTableCell cell, int rowIndex, int columnIndex) {
    }

    protected abstract int getNumberOfColumns();

    protected abstract int getNumberOfRows();

    protected abstract HtmlComponent getComponent(int var1, int var2);

    protected String getCellClasses(int rowIndex, int columnIndex) {
        return null;
    }

    protected boolean isHeader(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public void applyStyle(HtmlComponent component) {
        super.applyStyle(component);
        HtmlTable table = (HtmlTable)component;
        table.setCaption(this.getCaption());
        table.setSummary(this.getSummary());
        if (this.getHeaderClasses() != null) {
            HtmlTableHeader header;
            String[] headerClasses = null;
            if (this.getHeaderClasses() != null) {
                headerClasses = this.getHeaderClasses().split(",", -1);
            }
            if ((header = table.getHeader()) != null) {
                for (HtmlTableRow row : header.getRows()) {
                    int cellIndex = 0;
                    for (HtmlTableCell cell : row.getCells()) {
                        String choosenCellClass = headerClasses[cellIndex % headerClasses.length];
                        cell.setClasses(choosenCellClass);
                        ++cellIndex;
                    }
                }
            }
        }
        String[] rowClasses = null;
        if (this.getRowClasses() != null) {
            rowClasses = this.getRowClasses().split(",", -1);
        }
        String[] cellClasses = null;
        if (this.getColumnClasses() != null) {
            cellClasses = this.getColumnClasses().split(",", -1);
        }
        if (rowClasses == null && cellClasses == null) {
            return;
        }
        int rowIndex = 0;
        for (HtmlTableRow row : table.getRows()) {
            String chooseRowClass;
            if (rowClasses != null && !(chooseRowClass = rowClasses[rowIndex % rowClasses.length]).equals("")) {
                row.setClasses(chooseRowClass);
            }
            if (cellClasses != null) {
                int cellIndex = 0;
                for (HtmlTableCell cell : row.getCells()) {
                    String chooseCellClass = cellClasses[cellIndex % cellClasses.length];
                    if (!chooseCellClass.equals("")) {
                        cell.addClass(chooseCellClass);
                    }
                    ++cellIndex;
                }
            }
            ++rowIndex;
        }
    }
}

