/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.layouts;

import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public abstract class FlowLayout
extends Layout {
    private String eachClasses;
    private String eachStyle;
    private boolean eachInline = true;

    public void setEachClasses(String classes) {
        this.eachClasses = classes;
    }

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachStyle(String style) {
        this.eachStyle = style;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public boolean isEachInline() {
        return this.eachInline;
    }

    public void setEachInline(boolean eachInline) {
        this.eachInline = eachInline;
    }

    @Override
    public String[] getPropertyNames() {
        return this.mergePropertyNames(super.getPropertyNames(), new String[]{"eachClasses", "eachStyle", "eachInline"});
    }

    @Override
    public HtmlComponent createComponent(Object object, Class type) {
        HtmlComponent container = this.getContainer();
        while (this.hasMoreComponents()) {
            HtmlComponent component = this.getNextComponent();
            this.addComponent(container, component);
        }
        return container;
    }

    protected abstract boolean hasMoreComponents();

    protected abstract HtmlComponent getNextComponent();

    protected void addComponent(HtmlComponent component, HtmlComponent child) {
        HtmlContainer eachContainer = this.getEachContainer();
        eachContainer.addChild(child);
        ((HtmlContainer)component).addChild(eachContainer);
    }

    protected HtmlComponent getContainer() {
        return new HtmlInlineContainer();
    }

    protected HtmlContainer getEachContainer() {
        if (this.isEachInline()) {
            return new HtmlInlineContainer();
        }
        return new HtmlBlockContainer();
    }

    @Override
    public void applyStyle(HtmlComponent component) {
        super.applyStyle(component);
        String[] eachClasses = new String[]{null};
        if (this.eachClasses != null) {
            eachClasses = this.eachClasses.split(",", -1);
        }
        int index = 0;
        for (HtmlComponent child : component.getChildren()) {
            child.setClasses(eachClasses[index % eachClasses.length]);
            child.setStyle(this.eachStyle);
            ++index;
        }
    }
}

