/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import pt.ist.fenixWebFramework.renderers.ValuesRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlList;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;

public class ValuesAsListRenderer
extends ValuesRenderer {
    private String itemClasses;

    public String getItemClasses() {
        return this.itemClasses;
    }

    public void setItemClasses(String itemClasses) {
        this.itemClasses = itemClasses;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new ValuesAsListLayout(this.getContext().getMetaObject());
    }

    public class ValuesAsListLayout
    extends ValuesRenderer.ValuesLayout {
        String[] classes;
        HtmlList list;

        public ValuesAsListLayout(MetaObject object) {
            super(object);
            this.classes = ValuesAsListRenderer.this.getItemClasses() != null ? ValuesAsListRenderer.this.getItemClasses().split(",") : null;
        }

        public String getClasses(int index) {
            return this.classes != null && index < this.classes.length ? this.classes[index].trim() : null;
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            this.list = new HtmlList();
            while (this.hasMoreComponents()) {
                HtmlListItem item = this.list.createItem();
                item.addChild(this.getNextComponent());
            }
            return this.list;
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            int index = 0;
            for (HtmlComponent item : this.list.getChildren()) {
                item.setClasses(this.getClasses(index++));
            }
        }
    }
}

