/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixframework.DomainModelUtil;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.dml.DomainClass;
import pt.ist.fenixframework.dml.Slot;

public final class SchemaFactory {
    public static Schema create(Object object) {
        if (object instanceof DomainObject) {
            return SchemaFactory.getSchemaForDomainObject(object.getClass());
        }
        if (object instanceof DomainClass) {
            return SchemaFactory.getSchemaForDomainObject(((DomainClass)object).getFullName());
        }
        return SchemaFactory.create(object == null ? Object.class : object.getClass());
    }

    public static Schema create(Class<?> type) {
        if (DomainObject.class.isAssignableFrom(type)) {
            return SchemaFactory.getSchemaForDomainObject(type);
        }
        Schema schema = new Schema(type);
        if (Collection.class.isAssignableFrom(type)) {
            return schema;
        }
        List<String> filteredSlots = Arrays.asList("class");
        ArrayList<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>(Arrays.asList(PropertyUtils.getPropertyDescriptors(type)));
        for (PropertyDescriptor descriptor : descriptors) {
            if (filteredSlots.contains(descriptor.getName())) continue;
            schema.addSlotDescription(new SchemaSlotDescription(descriptor.getName()));
        }
        return schema;
    }

    private static Schema getSchemaForDomainObject(String name) {
        try {
            return SchemaFactory.getSchemaForDomainObject(Class.forName(name));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot create schema for unknown class: " + name, e);
        }
    }

    private static Schema getSchemaForDomainObject(Class<?> type) {
        Schema schema = new Schema(type);
        for (DomainClass domainClass = DomainModelUtil.getDomainClassFor(type); domainClass != null; domainClass = (DomainClass)domainClass.getSuperclass()) {
            for (Slot slot : domainClass.getSlotsList()) {
                schema.addSlotDescription(new SchemaSlotDescription(slot.getName()));
            }
        }
        return schema;
    }
}

