/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.TabularLayout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public class StandardObjectRenderer
extends OutputRenderer {
    private String caption;
    private String rowClasses;
    private String columnClasses;
    private String labelTerminator;

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getRowClasses() {
        return this.rowClasses;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public String getLabelTerminator() {
        return this.labelTerminator;
    }

    public void setLabelTerminator(String labelTerminator) {
        this.labelTerminator = labelTerminator;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new ObjectTabularLayout(this.getContext().getMetaObject());
    }

    class ObjectTabularLayout
    extends TabularLayout {
        private MetaObject object;

        public ObjectTabularLayout(MetaObject object) {
            this.object = object;
        }

        @Override
        protected int getNumberOfColumns() {
            return 2;
        }

        @Override
        protected int getNumberOfRows() {
            return this.object.getSlots().size();
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            return new HtmlText();
        }

        @Override
        protected boolean isHeader(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        protected HtmlComponent getComponent(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                MetaSlot slot = this.object.getSlots().get(rowIndex);
                return new HtmlText(this.addLabelTerminator(slot.getLabel()), false);
            }
            return StandardObjectRenderer.this.renderSlot(this.object.getSlots().get(rowIndex));
        }

        @Override
        protected void costumizeCell(HtmlTableCell cell, int rowIndex, int columnIndex) {
            super.costumizeCell(cell, rowIndex, columnIndex);
            if (columnIndex == 0) {
                cell.setScope("row");
            }
        }

        protected String addLabelTerminator(String label) {
            if (StandardObjectRenderer.this.getLabelTerminator() == null) {
                return label;
            }
            if (label == null) {
                return null;
            }
            if (label.endsWith(StandardObjectRenderer.this.getLabelTerminator())) {
                return label;
            }
            return label + StandardObjectRenderer.this.getLabelTerminator();
        }
    }
}

