/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.fenixedu.commons.i18n.I18N;
import pt.ist.fenixWebFramework.renderers.TextFieldRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.converters.DateConverter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class DateInputRenderer
extends TextFieldRenderer {
    private String format;

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format == null ? "dd/MM/yyyy" : this.format;
    }

    public boolean isFormatSet() {
        return this.format != null;
    }

    protected Locale getLocale() {
        return I18N.getLocale();
    }

    @Override
    protected HtmlComponent createTextField(Object object, Class type) {
        Date date = (Date)object;
        Locale locale = this.getLocale();
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getFormat(), locale);
        HtmlTextInput dateInput = new HtmlTextInput();
        if (date != null) {
            dateInput.setValue(dateFormat.format(date));
        }
        dateInput.setConverter(this.getDateConverter(dateFormat));
        dateInput.setPlaceholder(this.getFormatLabel());
        HtmlBlockContainer container = new HtmlBlockContainer();
        container.setClasses("input-group");
        container.addChild(dateInput);
        HtmlText text = new HtmlText(this.getFormatLabel());
        text.setClasses("input-group-addon");
        container.addChild(text);
        return container;
    }

    @Override
    protected String getFormatLabel() {
        if (this.isKey()) {
            return RenderUtils.getResourceString(this.getBundle(), this.getFormatText());
        }
        if (this.getFormatText() != null) {
            return this.getFormatText();
        }
        return this.getFormat();
    }

    protected Converter getDateConverter(SimpleDateFormat dateFormat) {
        return new DateConverter(dateFormat);
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new DateTextFieldLayout();
    }

    class DateTextFieldLayout
    extends TextFieldRenderer.TextFieldLayout {
        DateTextFieldLayout() {
        }

        @Override
        protected void setContextSlot(HtmlComponent component, MetaSlotKey slotKey) {
            HtmlContainer container = (HtmlContainer)component;
            super.setContextSlot(container.getChildren().get(0), slotKey);
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            HtmlContainer container = (HtmlContainer)component;
            super.applyStyle(container.getChildren().get(0));
        }
    }
}

