/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.SelectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBoxList;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLabel;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;

public class CheckBoxOptionListRenderer
extends SelectionRenderer {
    private String eachClasses;
    private String eachStyle;
    private String eachSchema;
    private String eachLayout;
    private boolean saveOptions;
    private boolean selectAllShown;
    private String checkBoxClasses;
    private String checkBoxStyle;
    private String listItemClasses;
    private String listItemStyle;
    private boolean ordered;

    public void setEachClasses(String classes) {
        this.eachClasses = classes;
    }

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachStyle(String style) {
        this.eachStyle = style;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public boolean isSelectAllShown() {
        return this.selectAllShown;
    }

    public void setSelectAllShown(boolean selectAllShown) {
        this.selectAllShown = selectAllShown;
    }

    public boolean isSaveOptions() {
        return this.saveOptions;
    }

    public void setSaveOptions(boolean saveOptions) {
        this.saveOptions = saveOptions;
    }

    public String getCheckBoxClasses() {
        return this.checkBoxClasses;
    }

    public void setCheckBoxClasses(String checkBoxClasses) {
        this.checkBoxClasses = checkBoxClasses;
    }

    public String getCheckBoxStyle() {
        return this.checkBoxStyle;
    }

    public void setCheckBoxStyle(String checkBoxStyle) {
        this.checkBoxStyle = checkBoxStyle;
    }

    public String getListItemClasses() {
        return this.listItemClasses;
    }

    public void setListItemClasses(String listItemClasses) {
        this.listItemClasses = listItemClasses;
    }

    public String getListItemStyle() {
        return this.listItemStyle;
    }

    public void setListItemStyle(String listItemStyle) {
        this.listItemStyle = listItemStyle;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new CheckBoxListLayout();
    }

    protected class CheckBoxListLayout
    extends Layout {
        protected CheckBoxListLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            List<MetaObject> possibleMetaObjects;
            Collection collection = (Collection)object;
            HtmlCheckBoxList listComponent = new HtmlCheckBoxList();
            listComponent.getList().setOrdered(CheckBoxOptionListRenderer.this.isOrdered());
            Schema schema = RenderKit.getInstance().findSchema(CheckBoxOptionListRenderer.this.getEachSchema());
            if (this.hasSavedPossibleMetaObjects()) {
                possibleMetaObjects = this.getPossibleMetaObjects();
            } else {
                possibleMetaObjects = new ArrayList<MetaObject>();
                for (MetaObject possibility : CheckBoxOptionListRenderer.this.getPossibleObjects()) {
                    possibleMetaObjects.add(MetaObjectFactory.createObject(possibility, schema));
                }
            }
            for (MetaObject metaObject : possibleMetaObjects) {
                Object obj = metaObject.getObject();
                MetaObjectKey key = metaObject.getKey();
                String layout = CheckBoxOptionListRenderer.this.getEachLayout();
                PresentationContext newContext = CheckBoxOptionListRenderer.this.getContext().createSubContext(metaObject);
                newContext.setLayout(layout);
                newContext.setRenderMode(RenderMode.OUTPUT);
                RenderKit kit = RenderKit.getInstance();
                HtmlComponent component = kit.render(newContext, obj);
                HtmlLabel label = new HtmlLabel();
                label.setBody(component);
                label.setStyle(CheckBoxOptionListRenderer.this.eachStyle);
                label.setClasses(CheckBoxOptionListRenderer.this.eachClasses);
                HtmlCheckBox checkBox = listComponent.addOption((HtmlComponent)label, key.toString());
                label.setFor(checkBox);
                checkBox.setClasses(CheckBoxOptionListRenderer.this.getCheckBoxClasses());
                checkBox.setStyle(CheckBoxOptionListRenderer.this.getCheckBoxStyle());
                if (collection == null || !collection.contains(obj)) continue;
                checkBox.setChecked(true);
            }
            listComponent.setSelectAllShown(listComponent.getList().getItems().size() > 1 && CheckBoxOptionListRenderer.this.isSelectAllShown());
            if (CheckBoxOptionListRenderer.this.isSaveOptions()) {
                this.savePossibleMetaObjects(possibleMetaObjects);
            }
            List<HtmlComponent> components = listComponent.getChildren(new Predicate<HtmlComponent>(){

                public boolean apply(HtmlComponent component) {
                    return component instanceof HtmlListItem;
                }
            });
            for (HtmlComponent component : components) {
                HtmlListItem listItem = (HtmlListItem)component;
                listItem.setStyle(CheckBoxOptionListRenderer.this.getListItemStyle());
                listItem.setClasses(CheckBoxOptionListRenderer.this.getListItemClasses());
            }
            listComponent.setConverter(new SelectionRenderer.MultipleSelectOptionConverter(possibleMetaObjects, CheckBoxOptionListRenderer.this.getConverter()));
            listComponent.setTargetSlot((MetaSlotKey)CheckBoxOptionListRenderer.this.getInputContext().getMetaObject().getKey());
            return listComponent;
        }

        private boolean hasSavedPossibleMetaObjects() {
            return CheckBoxOptionListRenderer.this.getInputContext().getViewState().getLocalAttribute("options") != null;
        }

        private List<MetaObject> getPossibleMetaObjects() {
            return (List)CheckBoxOptionListRenderer.this.getInputContext().getViewState().getLocalAttribute("options");
        }

        private void savePossibleMetaObjects(List<MetaObject> possibleMetaObjects) {
            CheckBoxOptionListRenderer.this.getInputContext().getViewState().setLocalAttribute("options", possibleMetaObjects);
        }
    }
}

