/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlList;
import pt.ist.fenixWebFramework.renderers.components.HtmlListItem;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlStyle;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;
import pt.ist.fenixframework.DomainObject;

public class TreeRenderer
extends OutputRenderer {
    private String treeId;
    private boolean expandable;
    private String fieldId;
    private String saveUrl;
    private boolean moduleRelative;
    private String saveParameter;
    private String onComplete;
    private String onError;
    private String eachLayout;
    private String eachSchema;
    private String image;
    private String children;
    private String links;
    private String hiddenLinks;
    private boolean includeImage;
    private String listClass;
    private String listStyle;
    private String itemClass;
    private String itemStyle;
    private String linksClasses;
    private String linksStyle;
    private String movedClass;
    private final Map<String, String> layoutsMap;
    private final Map<String, String> schemasMap;
    private final Map<String, String> childrenMap = new HashMap<String, String>();
    private final Map<String, String> noChildrenMap = new HashMap<String, String>();
    private final Map<String, String> classesMap = new HashMap<String, String>();
    private final Map<String, String> styleMap = new HashMap<String, String>();
    private final Map<String, String> linksMap = new HashMap<String, String>();
    private final Map<String, String> hiddenLinksMap = new HashMap<String, String>();
    private final Map<String, String> imagesMap = new HashMap<String, String>();
    private LevelDecorator decorator;
    private String current;
    private String currentClasses;
    private String currentStyle;

    public TreeRenderer() {
        this.layoutsMap = new HashMap<String, String>();
        this.schemasMap = new HashMap<String, String>();
        this.setStyle("margin: 0px; padding: 0px;");
        this.setListStyle("margin-left: 20px; padding-left: 20px;");
        this.setItemStyle("vertical-align:middle;");
        this.setModuleRelative(true);
        this.setIncludeImage(true);
    }

    public String getTreeId() {
        return this.treeId;
    }

    public void setTreeId(String treeId) {
        this.treeId = treeId;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public String getLayoutFor(String type) {
        return this.layoutsMap.get(type);
    }

    public void setLayoutFor(String type, String layout) {
        this.layoutsMap.put(type, layout);
    }

    public String getSchemaFor(String type) {
        return this.schemasMap.get(type);
    }

    public void setSchemaFor(String type, String schema) {
        this.schemasMap.put(type, schema);
    }

    public String getChildren() {
        return this.children;
    }

    public void setChildren(String children) {
        this.children = children;
    }

    public String getChildrenFor(String type) {
        return this.childrenMap.get(type);
    }

    public void setNoChildrenFor(String type, String value) {
        this.noChildrenMap.put(type, value);
    }

    public String getNoChildrenFor(String type) {
        return this.noChildrenMap.get(type);
    }

    public void setChildrenFor(String type, String method) {
        this.childrenMap.put(type, method);
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public String getSaveUrl() {
        return this.saveUrl;
    }

    public void setSaveUrl(String saveUrl) {
        this.saveUrl = saveUrl;
    }

    public boolean isModuleRelative() {
        return this.moduleRelative;
    }

    public void setModuleRelative(boolean moduleRelative) {
        this.moduleRelative = moduleRelative;
    }

    public String getSaveParameter() {
        return this.saveParameter;
    }

    public void setSaveParameter(String saveParameter) {
        this.saveParameter = saveParameter;
    }

    public String getOnComplete() {
        return this.onComplete;
    }

    public void setOnComplete(String onComplete) {
        this.onComplete = onComplete;
    }

    public String getOnError() {
        return this.onError;
    }

    public void setOnError(String onError) {
        this.onError = onError;
    }

    public String getListClass() {
        return this.listClass;
    }

    public void setListClass(String listClass) {
        this.listClass = listClass;
    }

    public String getListStyle() {
        return this.listStyle;
    }

    public void setListStyle(String listStyle) {
        this.listStyle = listStyle;
    }

    public String getItemClass() {
        return this.itemClass;
    }

    public void setItemClass(String itemClass) {
        this.itemClass = itemClass;
    }

    public String getItemStyle() {
        return this.itemStyle;
    }

    public void setItemStyle(String itemStyle) {
        this.itemStyle = itemStyle;
    }

    public String getClassesFor(String type) {
        return this.classesMap.get(type);
    }

    public void setClassesFor(String type, String method) {
        this.classesMap.put(type, method);
    }

    public String getLinks() {
        return this.links;
    }

    public void setLinks(String links) {
        this.links = links;
    }

    public String getHiddenLinks() {
        return this.hiddenLinks;
    }

    public void setHiddenLinks(String hiddenlinks) {
        this.hiddenLinks = hiddenlinks;
    }

    public String getLinksFor(String type) {
        return this.linksMap.get(type);
    }

    public void setLinksFor(String type, String method) {
        this.linksMap.put(type, method);
    }

    public String getHiddenLinksFor(String type) {
        return this.hiddenLinksMap.get(type);
    }

    public void setHiddenLinksFor(String type, String method) {
        this.hiddenLinksMap.put(type, method);
    }

    public String getLinksClasses() {
        return this.linksClasses;
    }

    public void setLinksClasses(String linksClass) {
        this.linksClasses = linksClass;
    }

    public String getLinksStyle() {
        return this.linksStyle;
    }

    public void setLinksStyle(String linksStyle) {
        this.linksStyle = linksStyle;
    }

    public String getMovedClass() {
        return this.movedClass;
    }

    public void setMovedClass(String moveClass) {
        this.movedClass = moveClass;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.setIncludeImage(false);
        this.image = image;
    }

    public String getImageFor(String type) {
        return this.imagesMap.get(type);
    }

    public void setImageFor(String type, String method) {
        this.setIncludeImage(false);
        this.imagesMap.put(type, method);
    }

    public boolean isIncludeImage() {
        return this.includeImage;
    }

    public void setIncludeImage(boolean includeImage) {
        this.includeImage = includeImage;
    }

    public String getCurrent() {
        return this.current;
    }

    public void setCurrent(String current) {
        this.current = current;
    }

    public String getCurrentClasses() {
        return this.currentClasses;
    }

    public void setCurrentClasses(String currentClasses) {
        this.currentClasses = currentClasses;
    }

    public String getCurrentStyle() {
        return this.currentStyle;
    }

    public void setCurrentStyle(String currentStyle) {
        this.currentStyle = currentStyle;
    }

    @Override
    public Layout getLayout(Object object, Class type) {
        return new TreeLayout();
    }

    public boolean isDraggable() {
        return this.getTreeId() != null && (this.getFieldId() != null || this.getSaveUrl() != null);
    }

    public boolean isExpandable() {
        return this.expandable || this.isDraggable();
    }

    public void setExpandable(boolean expandable) {
        this.expandable = expandable;
    }

    public LevelDecorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(LevelDecorator decorator) {
        this.decorator = decorator;
    }

    protected void beforeRecursion(Object object) {
    }

    protected void afterRecursion(Object object) {
    }

    protected HtmlComponent generateMainComponent(Object object) {
        Schema schema = RenderKit.getInstance().findSchema(this.getSchemaFor(object));
        return this.renderValue(object, object.getClass(), schema, this.getLayoutFor(object));
    }

    protected String getChildrenFor(Object object) {
        return this.getValueFor(object, this.childrenMap, this.getChildren());
    }

    protected String getNoChildrenFor(Object object) {
        return this.getValueFor(object, this.noChildrenMap, null);
    }

    protected String getClassFor(Object object) {
        return this.getValueFor(object, this.classesMap, this.getItemClass());
    }

    protected String getStyleFor(Object object) {
        return this.getValueFor(object, this.styleMap, null);
    }

    protected String getLinksFor(Object object) {
        return this.getValueFor(object, this.linksMap, this.getLinks());
    }

    protected String getHiddenLinksFor(Object object) {
        return this.getValueFor(object, this.hiddenLinksMap, this.getHiddenLinks());
    }

    protected String getImageFor(Object object) {
        return this.getValueFor(object, this.imagesMap, this.getImage());
    }

    protected String getSchemaFor(Object object) {
        return this.getValueFor(object, this.schemasMap, this.getEachSchema());
    }

    protected String getLayoutFor(Object object) {
        return this.getValueFor(object, this.layoutsMap, this.getEachLayout());
    }

    protected String getValueFor(Object object, Map<String, String> map, String defaultValue) {
        String value = null;
        String key = null;
        for (String type : map.keySet()) {
            if (!object.getClass().getName().contains(type) || key != null && key.length() >= type.length()) continue;
            key = type;
            value = map.get(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    protected boolean isIgnored(Object object) {
        return false;
    }

    protected Collection getChildrenObjects(Object object, String children) {
        return (Collection)RendererPropertyUtils.getProperty(object, children, false);
    }

    protected class TreeLayout
    extends Layout {
        protected TreeLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            HtmlList list = this.createList(new ArrayList<HtmlListItem>(), (Collection)object);
            if (TreeRenderer.this.isDraggable()) {
                return this.createScript(list, true);
            }
            if (TreeRenderer.this.isExpandable()) {
                return this.createScript(list, false);
            }
            return list;
        }

        private HtmlComponent createScript(HtmlList list, boolean drag) {
            String id = TreeRenderer.this.getTreeId();
            if (id == null && !drag) {
                id = "topLevelTree";
            }
            list.setId(id);
            HtmlLink imagesUrlLink = new HtmlLink();
            imagesUrlLink.setModuleRelative(false);
            imagesUrlLink.setUrl("/javaScript/drag-drop-folder-tree/images/");
            HtmlLink requestUrlLink = new HtmlLink();
            requestUrlLink.setModuleRelative(TreeRenderer.this.isModuleRelative());
            requestUrlLink.setUrl(TreeRenderer.this.getSaveUrl());
            String requestUrl = TreeRenderer.this.getSaveUrl() != null ? requestUrlLink.calculateUrl() : null;
            HtmlScript scriptA = new HtmlScript();
            scriptA.setContentType("text/javascript");
            scriptA.setScript(this.getTreeScript(id, requestUrl, imagesUrlLink.calculateUrl(), drag));
            HtmlStyle style = new HtmlStyle();
            style.setStyleBody((this.getStyle() != null ? String.format("#%s,#%s-container { %s }", id, id, this.getStyle()) : "") + "\n" + String.format("#%s ul { %s }", id, TreeRenderer.this.getListStyle()) + "\n" + String.format("#%s li,#%s-container li { %s }", id, id, TreeRenderer.this.getItemStyle()) + "\n");
            HtmlBlockContainer container = new HtmlBlockContainer();
            container.addChild(list);
            container.addChild(style);
            container.addChild(scriptA);
            return container;
        }

        private String getTreeScript(String id, String requestUrl, String imagesFolder, boolean drag) {
            StringBuilder script = new StringBuilder();
            script.append("treeRenderer_init('" + id + "', {");
            script.append("imageFolder: '" + imagesFolder + "'");
            script.append(", includeImage: " + TreeRenderer.this.isIncludeImage());
            if (drag) {
                if (requestUrl != null) {
                    script.append(", requestUrl: '" + requestUrl + "'");
                }
                if (TreeRenderer.this.getSaveParameter() != null) {
                    script.append(", requestParameter: '" + TreeRenderer.this.getSaveParameter() + "'");
                }
                if (TreeRenderer.this.getFieldId() != null) {
                    script.append(", fieldId: '" + TreeRenderer.this.getFieldId() + "'");
                }
                if (TreeRenderer.this.getOnComplete() != null) {
                    script.append(", onComplete: " + TreeRenderer.this.getOnComplete());
                }
                if (TreeRenderer.this.getOnError() != null) {
                    script.append(", onError: " + TreeRenderer.this.getOnError());
                }
                if (TreeRenderer.this.getMovedClass() != null) {
                    script.append(", movedClass: '" + TreeRenderer.this.getMovedClass() + "'");
                }
            } else {
                script.append(", disableDrag: true");
            }
            if (this.getUsableLinksClasses() != null) {
                script.append(", linkClasses: '" + this.getUsableLinksClasses() + "'");
            }
            script.append("});");
            return script.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HtmlList createList(List<HtmlListItem> itemPath, Collection collection) {
            HtmlList list = new HtmlList();
            list.setClasses(TreeRenderer.this.getListClass());
            if (collection == null) {
                return list;
            }
            for (Object object : collection) {
                DomainObject domainObject;
                HtmlComponent decoratorComponent;
                LevelDecorator decorator;
                if (TreeRenderer.this.isIgnored(object)) continue;
                HtmlListItem item = list.createItem();
                item.setClasses(TreeRenderer.this.getClassFor(object));
                item.setStyle(TreeRenderer.this.getStyleFor(object));
                HtmlComponent component = TreeRenderer.this.generateMainComponent(object);
                String imageUrl = TreeRenderer.this.getImageFor(object);
                if (imageUrl != null) {
                    HtmlLink imageLink = new HtmlLink();
                    imageLink.setModuleRelative(false);
                    imageLink.setUrl(imageUrl);
                    HtmlImage image = new HtmlImage();
                    image.setSource(imageLink.calculateUrl());
                    item.addChild(image);
                }
                if ((decorator = TreeRenderer.this.getDecorator()) != null && (decoratorComponent = decorator.decorate(object)) != null) {
                    item.addChild(decoratorComponent);
                }
                item.addChild(component);
                String linksForItem = TreeRenderer.this.getLinksFor(object);
                String hiddenLinksForItem = TreeRenderer.this.getHiddenLinksFor(object);
                if (linksForItem != null || hiddenLinksForItem != null) {
                    HtmlInlineContainer linksContainer = new HtmlInlineContainer();
                    linksContainer.setClasses(this.getUsableLinksClasses());
                    linksContainer.setStyle(TreeRenderer.this.getLinksStyle());
                    if (hiddenLinksForItem != null) {
                        HtmlInlineContainer hiddenContainer = new HtmlInlineContainer();
                        hiddenContainer.addChild(new HtmlText(RenderUtils.getFormattedProperties(hiddenLinksForItem, object), false));
                        linksContainer.addChild(hiddenContainer);
                    }
                    linksContainer.addChild(new HtmlText(RenderUtils.getFormattedProperties(linksForItem, object), false));
                    item.addChild(linksContainer);
                }
                boolean current = false;
                if (TreeRenderer.this.getCurrent() != null && (domainObject = (DomainObject)object).getExternalId().toString().equals(TreeRenderer.this.getCurrent())) {
                    current = true;
                    for (HtmlListItem level : itemPath) {
                        level.setAttribute("expanded", "true");
                    }
                    component.setClasses(TreeRenderer.this.getCurrentClasses());
                    component.setStyle(TreeRenderer.this.getCurrentStyle());
                }
                try {
                    boolean noChildren;
                    String children = TreeRenderer.this.getChildrenFor(object);
                    boolean bl = noChildren = TreeRenderer.this.getNoChildrenFor(object) != null;
                    if (children != null && !noChildren) {
                        Collection subCollection = TreeRenderer.this.getChildrenObjects(object, children);
                        if (subCollection == null || subCollection.isEmpty()) continue;
                        try {
                            itemPath.add(item);
                            if (current) {
                                item.setAttribute("expanded", "true");
                            }
                            TreeRenderer.this.beforeRecursion(object);
                            HtmlList subList = this.createList(itemPath, subCollection);
                            TreeRenderer.this.afterRecursion(object);
                            if (subList.getChildren().isEmpty()) continue;
                            item.addChild(subList);
                            continue;
                        }
                        finally {
                            itemPath.remove(item);
                            continue;
                        }
                    }
                    item.setAttribute("noChildren", "true");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return list;
        }

        private String getUsableLinksClasses() {
            if (TreeRenderer.this.getLinksClasses() == null) {
                if (TreeRenderer.this.getTreeId() != null) {
                    return TreeRenderer.this.getTreeId() + "-links";
                }
                return null;
            }
            return TreeRenderer.this.getLinksClasses();
        }
    }

    public static interface LevelDecorator {
        public HtmlComponent decorate(Object var1);
    }
}

