/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.model;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.fenixedu.bennu.core.domain.User;
import pt.ist.fenixWebFramework.rendererExtensions.validators.RequiredAutoCompleteSelectionValidator;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;
import pt.ist.fenixWebFramework.renderers.validators.RequiredValidator;
import pt.ist.fenixWebFramework.renderers.validators.ValidatorProperties;

public class MetaSlot
extends MetaObject {
    private final MetaObject metaObject;
    private final String name;
    private String bundle;
    private String labelKey;
    private String labelArg0;
    private String layout;
    private List<ValidatorProperties> validators = new ArrayList<ValidatorProperties>();
    private Class<Converter> converter;
    private String defaultValue;
    private boolean readOnly;
    private boolean setterIgnored;
    private String helpLabel;
    private boolean isCached;
    private MetaObject valueMetaObject;
    private String description;
    private String descriptionFormat;

    public MetaSlot(MetaObject metaObject, String name) {
        this.metaObject = metaObject;
        this.name = name;
        this.valueMetaObject = null;
    }

    public MetaObject getMetaObject() {
        return this.metaObject;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public MetaSlotKey getKey() {
        return new MetaSlotKey(this.getMetaObject(), this.getName());
    }

    public boolean hasValidator() {
        return this.getValidators() != null && !this.getValidators().isEmpty();
    }

    public String getLabel() {
        Object object = this.getMetaObject().getObject();
        if (object != null) {
            if (this.getLabelArg0() == null) {
                return RenderUtils.getSlotLabel(object.getClass(), this.getName(), this.getBundle(), this.getLabelKey(), new String[0]);
            }
            return RenderUtils.getSlotLabel(object.getClass(), this.getName(), this.getBundle(), this.getLabelKey(), this.getLabelArg0());
        }
        Class<?> type = this.getMetaObject().getSchema() != null ? this.getMetaObject().getSchema().getType() : this.getMetaObject().getType();
        if (this.getLabelArg0() == null) {
            return RenderUtils.getSlotLabel(type, this.getName(), this.getBundle(), this.getLabelKey(), new String[0]);
        }
        return RenderUtils.getSlotLabel(type, this.getName(), this.getBundle(), this.getLabelKey(), this.getLabelArg0());
    }

    public void setLabelKey(String key) {
        this.labelKey = key;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getLabelArg0() {
        return this.labelArg0;
    }

    public void setLabelArg0(String labelArg0) {
        this.labelArg0 = labelArg0;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setDescriptionFormat(String descriptionFormat) {
        this.descriptionFormat = descriptionFormat;
    }

    public String getDescriptionFormat() {
        return this.descriptionFormat;
    }

    public boolean hasConverter() {
        return this.converter != null;
    }

    public Class<Converter> getConverter() {
        return this.converter;
    }

    public void setConverter(Class<Converter> converter) {
        this.converter = converter;
    }

    public boolean isCached() {
        return this.isCached;
    }

    protected void setCached(boolean isCached) {
        this.isCached = isCached;
    }

    @Override
    public Object getObject() {
        if (this.isCached()) {
            return this.getValueMetaObject().getObject();
        }
        try {
            if (this.getName().equals("this")) {
                return this.getMetaObject().getObject();
            }
            return PropertyUtils.getProperty((Object)this.getMetaObject().getObject(), (String)this.getName());
        }
        catch (Exception e) {
            throw new RuntimeException("could not read property '" + this.getName() + "' from object " + this.getMetaObject().getObject(), e);
        }
    }

    @Override
    public Class getType() {
        if (this.getObject() != null) {
            return this.getObject().getClass();
        }
        return this.getStaticType();
    }

    public Class getStaticType() {
        return RendererPropertyUtils.getPropertyType(this.getMetaObject().getType(), this.getName());
    }

    public void setObject(Object object) {
        this.setValueMetaObject(object);
        this.setCached(true);
    }

    protected void setValueMetaObject(MetaObject metaObject) {
        this.valueMetaObject = metaObject;
        if (this.valueMetaObject != null) {
            this.valueMetaObject.setUser(this.getUser());
        }
    }

    private void setValueMetaObject(Object object) {
        this.setValueMetaObject(MetaObjectFactory.createObject(object, this.getSchema()));
    }

    protected MetaObject getValueMetaObject() {
        if (this.valueMetaObject == null) {
            this.setValueMetaObject(this.getObject());
        }
        return this.valueMetaObject;
    }

    @Override
    public void setUser(User user) {
        User metaObjetUser;
        if (!(this.getMetaObject() == null || (metaObjetUser = this.getMetaObject().getUser()) != null && metaObjetUser.equals((Object)user))) {
            this.getMetaObject().setUser(user);
        }
        if (this.valueMetaObject != null) {
            this.valueMetaObject.setUser(user);
        }
    }

    @Override
    public User getUser() {
        if (this.getMetaObject() != null) {
            return this.getMetaObject().getUser();
        }
        return null;
    }

    @Override
    public List<MetaSlot> getSlots() {
        MetaObject valueMetaObject = this.getValueMetaObject();
        return valueMetaObject.getSlots();
    }

    @Override
    public void addSlot(MetaSlot slot) {
    }

    @Override
    public boolean removeSlot(MetaSlot slot) {
        return false;
    }

    @Override
    public List<MetaSlot> getHiddenSlots() {
        MetaObject valueMetaObject = this.getValueMetaObject();
        return valueMetaObject.getHiddenSlots();
    }

    @Override
    public void addHiddenSlot(MetaSlot slot) {
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isSetterIgnored() {
        return this.setterIgnored;
    }

    public void setSetterIgnored(boolean setterIgnored) {
        this.setterIgnored = setterIgnored;
    }

    @Override
    protected void commit() {
        this.getMetaObject().commit();
    }

    public List<ValidatorProperties> getValidators() {
        return this.validators;
    }

    public List<HtmlValidator> getValidatorsList() {
        ArrayList<HtmlValidator> validators = new ArrayList<HtmlValidator>();
        for (ValidatorProperties validatorPair : this.validators) {
            try {
                Constructor<HtmlValidator> constructor = validatorPair.getType().getConstructor(new Class[0]);
                HtmlValidator validator = constructor.newInstance(new Object[0]);
                RenderUtils.setProperties(validator, validatorPair.getProperties());
                validators.add(validator);
            }
            catch (Exception e) {
                throw new RuntimeException("could not create validator '" + validatorPair.getType().getName() + "' for slot '" + this.getName() + "': ", e);
            }
        }
        return validators;
    }

    public void setValidators(List<ValidatorProperties> validators) {
        if (validators != null) {
            this.validators = validators;
        }
    }

    public boolean isRequired() {
        for (ValidatorProperties validator : this.getValidators()) {
            if (!RequiredAutoCompleteSelectionValidator.class.isAssignableFrom(validator.getType()) && !RequiredValidator.class.isAssignableFrom(validator.getType())) continue;
            return true;
        }
        return false;
    }

    public String getHelpLabel() {
        return this.helpLabel;
    }

    public void setHelpLabel(String helpLabel) {
        this.helpLabel = helpLabel;
    }

    public boolean hasHelp() {
        return this.getHelpLabel() != null;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTitle() {
        String label = null;
        String key = this.getDescription();
        if (key != null) {
            label = RenderUtils.getResourceString(this.bundle, key);
        }
        if (label != null) {
            return label;
        }
        String labelFormat = this.getDescriptionFormat();
        Object object = this.getMetaObject().getObject();
        if (object != null && labelFormat != null) {
            return RenderUtils.getFormattedProperties(labelFormat, object);
        }
        Class<?> type = this.getMetaObject().getSchema() != null ? this.getMetaObject().getSchema().getType() : this.getMetaObject().getType();
        return RenderUtils.getSlotLabel(type, this.getName(), this.getBundle(), this.getDescription(), new String[0]);
    }
}

