/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.SelectionRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLabel;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButtonList;
import pt.ist.fenixWebFramework.renderers.components.converters.BiDirectionalConverter;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class RadioButtonListRenderer
extends SelectionRenderer {
    private String format;
    private String eachClasses;
    private String eachStyle;
    private String eachSchema;
    private String eachLayout;
    private boolean saveOptions;
    private String nullOptionKey;
    private String nullOptionBundle;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setEachClasses(String classes) {
        this.eachClasses = classes;
    }

    public String getEachClasses() {
        return this.eachClasses;
    }

    public void setEachStyle(String style) {
        this.eachStyle = style;
    }

    public String getEachStyle() {
        return this.eachStyle;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public boolean isSaveOptions() {
        return this.saveOptions;
    }

    public void setSaveOptions(boolean saveOptions) {
        this.saveOptions = saveOptions;
    }

    public void setNullOptionKey(String nullOptionKey) {
        this.nullOptionKey = nullOptionKey;
    }

    public String getNullOptionKey() {
        return this.nullOptionKey;
    }

    public void setNullOptionBundle(String nullOptionLabel) {
        this.nullOptionBundle = nullOptionLabel;
    }

    public String getNullOptionBundle() {
        return this.nullOptionBundle;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new RadioButtonListLayout();
    }

    class RadioButtonListLayout
    extends Layout {
        RadioButtonListLayout() {
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            List<MetaObject> possibleMetaObjects;
            HtmlRadioButtonList listComponent = new HtmlRadioButtonList();
            Schema schema = RenderKit.getInstance().findSchema(RadioButtonListRenderer.this.getEachSchema());
            if (this.hasSavedPossibleMetaObjects()) {
                possibleMetaObjects = this.getPossibleMetaObjects();
            } else {
                possibleMetaObjects = new ArrayList<MetaObject>();
                for (MetaObject possibility : RadioButtonListRenderer.this.getPossibleObjects()) {
                    possibleMetaObjects.add(MetaObjectFactory.createObject(possibility, schema));
                }
            }
            for (MetaObject metaObject : possibleMetaObjects) {
                Object obj = metaObject.getObject();
                MetaObjectKey key = metaObject.getKey();
                String layout = RadioButtonListRenderer.this.getEachLayout();
                HtmlLabel label = new HtmlLabel();
                if (Strings.isNullOrEmpty((String)layout)) {
                    if (Enum.class.isAssignableFrom(obj.getClass()) && Strings.isNullOrEmpty((String)RadioButtonListRenderer.this.getFormat())) {
                        this.fillBodyForRadioLabel(metaObject, obj, layout, label);
                    } else {
                        label.setText(this.getObjectLabel(obj));
                    }
                } else {
                    this.fillBodyForRadioLabel(metaObject, obj, layout, label);
                }
                label.setStyle(RadioButtonListRenderer.this.eachStyle);
                label.setClasses(RadioButtonListRenderer.this.eachClasses);
                String optionValue = RadioButtonListRenderer.this.getConverter() instanceof BiDirectionalConverter ? ((BiDirectionalConverter)RadioButtonListRenderer.this.getConverter()).deserialize(obj) : key.toString();
                HtmlRadioButton radioButton = listComponent.addOption(label, optionValue);
                label.setFor(radioButton);
                if (object == null || !object.equals(obj)) continue;
                radioButton.setChecked(true);
            }
            if (!Strings.isNullOrEmpty((String)RadioButtonListRenderer.this.getNullOptionKey())) {
                HtmlLabel label = new HtmlLabel();
                label.setText(RenderUtils.getResourceString(RadioButtonListRenderer.this.getNullOptionBundle(), RadioButtonListRenderer.this.getNullOptionKey()));
                HtmlRadioButton addOption = listComponent.addOption(label, null);
                if (object == null) {
                    addOption.setChecked(true);
                }
            }
            if (RadioButtonListRenderer.this.isSaveOptions()) {
                this.savePossibleMetaObjects(possibleMetaObjects);
            }
            listComponent.setConverter(new SelectionRenderer.SingleSelectOptionConverter(possibleMetaObjects, RadioButtonListRenderer.this.getConverter()));
            listComponent.setTargetSlot((MetaSlotKey)RadioButtonListRenderer.this.getInputContext().getMetaObject().getKey());
            return listComponent;
        }

        private void fillBodyForRadioLabel(MetaObject metaObject, Object obj, String layout, HtmlLabel label) {
            PresentationContext newContext = RadioButtonListRenderer.this.getContext().createSubContext(metaObject);
            newContext.setLayout(layout);
            newContext.setRenderMode(RenderMode.OUTPUT);
            RenderKit kit = RenderKit.getInstance();
            HtmlComponent component = kit.render(newContext, obj);
            label.setBody(component);
        }

        private boolean hasSavedPossibleMetaObjects() {
            return RadioButtonListRenderer.this.getInputContext().getViewState().getLocalAttribute("options") != null;
        }

        private List<MetaObject> getPossibleMetaObjects() {
            return (List)RadioButtonListRenderer.this.getInputContext().getViewState().getLocalAttribute("options");
        }

        private void savePossibleMetaObjects(List<MetaObject> possibleMetaObjects) {
            RadioButtonListRenderer.this.getInputContext().getViewState().setLocalAttribute("options", possibleMetaObjects);
        }

        protected String getObjectLabel(Object object) {
            if (RadioButtonListRenderer.this.getFormat() != null) {
                return RenderUtils.getFormattedProperties(RadioButtonListRenderer.this.getFormat(), object);
            }
            return String.valueOf(object);
        }
    }
}

