/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public class DecimalRenderer
extends OutputRenderer {
    private String format;
    private String negativeStyle;
    private String positiveStyle;
    private char decimalSeparator;
    private char groupingSeparator;
    private String currencySymbol;
    private static final String DEFAULT_FORMAT = "######0.00";

    public DecimalRenderer() {
        this.setFormat(DEFAULT_FORMAT);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormat(this.getFormat()).getDecimalFormatSymbols();
        this.setDecimalSeparator(decimalFormatSymbols.getDecimalSeparator());
        this.setGroupingSeparator(decimalFormatSymbols.getGroupingSeparator());
        this.setCurrencySymbol(decimalFormatSymbols.getCurrencySymbol());
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlText htmlText = new HtmlText(this.getDecimalFormat().format(object));
                if (object != null && ((Number)object).doubleValue() < 0.0) {
                    this.setStyle(DecimalRenderer.this.getNegativeStyle());
                } else {
                    this.setStyle(DecimalRenderer.this.getPositiveStyle());
                }
                return htmlText;
            }

            private DecimalFormat getDecimalFormat() {
                DecimalFormat decimalFormat = new DecimalFormat(DecimalRenderer.this.getFormat());
                DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
                decimalFormatSymbols.setDecimalSeparator(DecimalRenderer.this.getDecimalSeparator());
                decimalFormatSymbols.setMonetaryDecimalSeparator(decimalFormatSymbols.getDecimalSeparator());
                decimalFormatSymbols.setGroupingSeparator(DecimalRenderer.this.getGroupingSeparator());
                decimalFormatSymbols.setCurrencySymbol(DecimalRenderer.this.getCurrencySymbol());
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                return decimalFormat;
            }
        };
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getNegativeStyle() {
        return this.negativeStyle;
    }

    public void setNegativeStyle(String negativeStyle) {
        this.negativeStyle = negativeStyle;
    }

    public String getPositiveStyle() {
        return this.positiveStyle;
    }

    public void setPositiveStyle(String positiveStyle) {
        this.positiveStyle = positiveStyle;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setDecimalSeparator(char decimalSeparator) {
        this.decimalSeparator = decimalSeparator;
    }

    public char getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setGroupingSeparator(char groupingSeparator) {
        this.groupingSeparator = groupingSeparator;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setCurrencySymbol(String currencySymbol) {
        this.currencySymbol = currencySymbol;
    }
}

