/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.htmlEditor;

import javax.servlet.http.HttpServletRequest;
import pt.ist.fenixWebFramework.rendererExtensions.components.HtmlEditor;
import pt.ist.fenixWebFramework.rendererExtensions.htmlEditor.JsoupSafeHtmlConverter;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlSubmitButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextArea;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;

public class HtmlEditorRenderer
extends InputRenderer {
    private int columns;
    private int rows;
    private int heigth;
    private int width;
    private boolean safe;

    public HtmlEditorRenderer() {
        this.setWidth(600);
        this.setHeigth(400);
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getHeigth() {
        return this.heigth;
    }

    public void setHeigth(int heigth) {
        this.heigth = heigth;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new EditorLayout();
    }

    private class EditorLayout
    extends Layout {
        private EditorLayout() {
        }

        private boolean isBrowserSupported() {
            String[] notSupported = new String[]{"safari", "konqueror", "opera"};
            HttpServletRequest request = HtmlEditorRenderer.this.getInputContext().getViewState().getRequest();
            String userAgent = request.getHeader("User-Agent");
            if (userAgent == null) {
                return false;
            }
            userAgent = userAgent.toLowerCase();
            for (String id : notSupported) {
                if (userAgent.indexOf(id) == -1) continue;
                return false;
            }
            return true;
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            if (!this.isBrowserSupported()) {
                return this.createTextArea(object, type);
            }
            return this.createEditor(object, type);
        }

        private HtmlComponent createEditor(Object object, Class type) {
            HtmlInlineContainer container = new HtmlInlineContainer();
            HtmlEditor editor = new HtmlEditor();
            editor.setWidth(HtmlEditorRenderer.this.getWidth());
            editor.setHeigth(HtmlEditorRenderer.this.getHeigth());
            editor.setValue((String)object);
            editor.setTargetSlot((MetaSlotKey)HtmlEditorRenderer.this.getInputContext().getMetaObject().getKey());
            if (HtmlEditorRenderer.this.isSafe()) {
                editor.setConverter(new JsoupSafeHtmlConverter());
            }
            HtmlSubmitButton submitButton = HtmlEditorRenderer.this.getInputContext().getForm().getSubmitButton();
            String currentScript = submitButton.getOnClick();
            submitButton.setOnClick("updateRTE('" + editor.getName() + "');" + (currentScript == null ? "" : currentScript));
            container.addChild(editor);
            return container;
        }

        private HtmlComponent createTextArea(Object object, Class type) {
            HtmlTextArea textArea = new HtmlTextArea();
            textArea.setTargetSlot((MetaSlotKey)HtmlEditorRenderer.this.getInputContext().getMetaObject().getKey());
            if (HtmlEditorRenderer.this.isSafe()) {
                textArea.setConverter(new JsoupSafeHtmlConverter());
            }
            textArea.setValue((String)object);
            textArea.setColumns(HtmlEditorRenderer.this.getColumns());
            textArea.setRows(HtmlEditorRenderer.this.getRows());
            return textArea;
        }
    }
}

