/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.fenixedu.commons.i18n.I18N;
import org.joda.time.DateTime;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlInlineContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextInput;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.converters.DateConverter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class DateTimeInputRenderer
extends InputRenderer {
    private String dateFormat;
    private String dateFormatText;
    private String dateBundle;
    private boolean dateKey;
    private String dateSize;
    private Integer dateMaxLength;

    public String getDateFormat() {
        return this.dateFormat == null ? "dd/MM/yyyy" : this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormatText() {
        return this.dateFormatText;
    }

    public void setDateFormatText(String dateFormatText) {
        this.dateFormatText = dateFormatText;
    }

    public String getDateBundle() {
        return this.dateBundle;
    }

    public void setDateBundle(String dateBundle) {
        this.dateBundle = dateBundle;
    }

    public boolean isDateKey() {
        return this.dateKey;
    }

    public void setDateKey(boolean dateKey) {
        this.dateKey = dateKey;
    }

    public Integer getDateMaxLength() {
        return this.dateMaxLength;
    }

    public void setDateMaxLength(Integer dateMaxLength) {
        this.dateMaxLength = dateMaxLength;
    }

    public String getDateSize() {
        return this.dateSize;
    }

    public void setDateSize(String dateSize) {
        this.dateSize = dateSize;
    }

    protected Locale getLocale() {
        return I18N.getLocale();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new DateTimeLayout();
    }

    public class DateTimeLayout
    extends Layout {
        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            DateTime dateTime = (DateTime)object;
            Date date = null;
            Calendar calendar = null;
            if (dateTime != null) {
                date = dateTime.toGregorianCalendar().getTime();
                calendar = Calendar.getInstance();
                calendar.setTime(date);
            }
            MetaSlotKey key = (MetaSlotKey)DateTimeInputRenderer.this.getInputContext().getMetaObject().getKey();
            HtmlInlineContainer container = new HtmlInlineContainer();
            container.addClass("form-inline");
            HtmlHiddenField hiddenField = new HtmlHiddenField();
            hiddenField.setTargetSlot(key);
            container.addChild(hiddenField);
            HtmlTextInput dateField = new HtmlTextInput();
            dateField.setName(key.toString() + "_date");
            dateField.setSize(DateTimeInputRenderer.this.getDateSize());
            dateField.setMaxLength(DateTimeInputRenderer.this.getDateMaxLength());
            container.addChild(dateField);
            container.addChild(new HtmlText(this.getFormatLabel()));
            Locale locale = DateTimeInputRenderer.this.getLocale();
            SimpleDateFormat dateFormat = new SimpleDateFormat(DateTimeInputRenderer.this.getDateFormat(), locale);
            if (date != null) {
                dateField.setValue(dateFormat.format(date));
            }
            HtmlTextInput hoursField = new HtmlTextInput();
            hoursField.setName(key.toString() + "_hours");
            hoursField.setSize("2");
            hoursField.setMaxLength(2);
            container.addChild(hoursField);
            if (calendar != null) {
                hoursField.setValue(String.format("%02d", calendar.get(11)));
            }
            container.addChild(new HtmlText("hh"));
            HtmlTextInput minutesField = new HtmlTextInput();
            minutesField.setName(key.toString() + "_minutes");
            minutesField.setSize("2");
            minutesField.setMaxLength(2);
            container.addChild(minutesField);
            if (calendar != null) {
                minutesField.setValue(String.format("%02d", calendar.get(12)));
            }
            container.addChild(new HtmlText("mm"));
            hiddenField.setConverter(new DateTimeConverter(dateField, hoursField, minutesField));
            minutesField.setController(new DateTimeController(hiddenField, dateFormat, dateField, hoursField, minutesField));
            return container;
        }

        protected String getFormatLabel() {
            if (DateTimeInputRenderer.this.isDateKey()) {
                return RenderUtils.getResourceString(DateTimeInputRenderer.this.getDateBundle(), DateTimeInputRenderer.this.getDateFormatText());
            }
            if (DateTimeInputRenderer.this.getDateFormatText() != null) {
                return DateTimeInputRenderer.this.getDateFormatText();
            }
            return DateTimeInputRenderer.this.getDateFormat();
        }
    }

    public static class DateTimeConverter
    extends Converter {
        public static final String INVALID = "invalid";
        public static final String INCOMPLETE = "incomplete";
        private final HtmlTextInput dateField;
        private final HtmlTextInput hoursField;
        private final HtmlTextInput minutesField;

        public DateTimeConverter(HtmlTextInput dateField, HtmlTextInput hoursField, HtmlTextInput minutesField) {
            this.dateField = dateField;
            this.hoursField = hoursField;
            this.minutesField = minutesField;
        }

        @Override
        public Object convert(Class type, Object value) {
            if (value == null || String.valueOf(value).length() == 0) {
                return null;
            }
            if (value.equals(INVALID)) {
                throw new ConversionException("fenix.renderers.converter.dateTime.invalid", true, this.dateField.getValue());
            }
            String hours = DateTimeConverter.zeroPad(this.hoursField.getValue());
            String minutes = DateTimeConverter.zeroPad(this.minutesField.getValue());
            if (value.equals(INCOMPLETE)) {
                throw new ConversionException("fenix.renderers.converter.dateTime.incomplete", true, hours, minutes);
            }
            try {
                return new DateTime(value);
            }
            catch (IllegalArgumentException e) {
                String date = this.dateField.getValue();
                throw new ConversionException("fenix.renderers.converter.dateTime.convert", (Throwable)e, true, date, hours, minutes);
            }
        }

        public static String zeroPad(String text) {
            if (text == null) {
                return "00";
            }
            return (text.length() < 2 ? "0" : "") + (text.length() < 1 ? "0" : "") + text;
        }
    }

    private class DateTimeController
    extends HtmlController {
        private final HtmlHiddenField valueField;
        private final DateFormat dateFormat;
        private final HtmlTextInput dateField;
        private final HtmlTextInput hoursField;
        private final HtmlTextInput minutesField;

        public DateTimeController(HtmlHiddenField hiddenField, DateFormat dateFormat, HtmlTextInput dateField, HtmlTextInput hoursField, HtmlTextInput minutesField) {
            this.valueField = hiddenField;
            this.dateFormat = dateFormat;
            this.dateField = dateField;
            this.hoursField = hoursField;
            this.minutesField = minutesField;
        }

        @Override
        public void execute(IViewState viewState) {
            DateConverter converter = new DateConverter(this.dateFormat);
            try {
                Date date = (Date)converter.convert(Date.class, this.dateField.getValue());
                if (date == null) {
                    if (this.hoursField.getValue() != null && this.hoursField.getValue().length() > 0 || this.minutesField.getValue() != null && this.minutesField.getValue().length() > 0) {
                        this.valueField.setValue("incomplete");
                    } else {
                        this.valueField.setValue("");
                    }
                    return;
                }
                String hours = DateTimeConverter.zeroPad(this.hoursField.getValue());
                String minutes = DateTimeConverter.zeroPad(this.minutesField.getValue());
                String value = String.format("%tFT%s:%s", date, hours, minutes);
                this.valueField.setValue(value);
            }
            catch (ConversionException e) {
                this.valueField.setValue("invalid");
            }
        }
    }
}

