/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.schemas;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixWebFramework.renderers.schemas.Signature;
import pt.ist.fenixWebFramework.renderers.schemas.SignatureParameter;

public class Schema {
    private final String name;
    private Class type;
    private final List<SchemaSlotDescription> slotDescriptions;
    private Signature constructor;
    private final List<Signature> setters;

    public Schema(String name, Class type) {
        this.name = name;
        this.type = type;
        this.slotDescriptions = new ArrayList<SchemaSlotDescription>();
        this.setters = new ArrayList<Signature>();
    }

    public Schema(String name, Class type, Schema baseSchema) {
        this(name, type);
        if (baseSchema != null) {
            for (SchemaSlotDescription slotDescription : baseSchema.getSlotDescriptions()) {
                this.addSlotDescription(slotDescription);
            }
            for (Signature signature : baseSchema.getSpecialSetters()) {
                this.addSpecialSetter(signature);
            }
        }
    }

    public Schema(Class type) {
        this(null, type);
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public Signature getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Signature constructor) {
        this.constructor = constructor;
    }

    public List<SchemaSlotDescription> getSlotDescriptions() {
        return this.slotDescriptions;
    }

    public SchemaSlotDescription getSlotDescription(String slotName) {
        for (SchemaSlotDescription slotDescription : this.getSlotDescriptions()) {
            if (!slotDescription.getSlotName().equals(slotName)) continue;
            return slotDescription;
        }
        return null;
    }

    public void addSlotDescription(SchemaSlotDescription slotDescription) {
        int index = this.findSlotIndex(slotDescription.getSlotName());
        if (index != -1) {
            this.slotDescriptions.set(index, slotDescription);
        } else {
            this.slotDescriptions.add(slotDescription);
        }
    }

    private int findSlotIndex(String name) {
        int i = 0;
        for (SchemaSlotDescription slotDescription : this.slotDescriptions) {
            if (slotDescription.getSlotName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeSlotDescription(SchemaSlotDescription slotDescription) {
        if (this.slotDescriptions.remove(slotDescription)) {
            Iterator<Signature> iter = this.getSpecialSetters().iterator();
            block0: while (iter.hasNext()) {
                Signature signature = iter.next();
                for (SignatureParameter parameter : signature.getParameters()) {
                    if (!parameter.getSlotDescription().equals(slotDescription)) continue;
                    iter.remove();
                    continue block0;
                }
            }
        }
    }

    public void addSpecialSetter(Signature setterSignature) {
        this.setters.add(setterSignature);
    }

    public List<Signature> getSpecialSetters() {
        return this.setters;
    }
}

