/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pt.ist.fenixWebFramework.renderers.exceptions.NoRendererException;
import pt.ist.fenixWebFramework.renderers.exceptions.NoSuchSchemaException;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.schemas.SchemaSlotDescription;
import pt.ist.fenixWebFramework.renderers.schemas.Signature;
import pt.ist.fenixWebFramework.renderers.schemas.SignatureParameter;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RendererPropertyUtils;
import pt.ist.fenixWebFramework.renderers.validators.RequiredValidator;
import pt.ist.fenixWebFramework.renderers.validators.ValidatorProperties;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.core.Project;

public class ConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationReader.class);

    public static void readSchemas(URL schemaConfig, ServletContext ctx) throws ServletException {
        Document root = ConfigurationReader.readConfigRootElement(schemaConfig, ctx);
        if (root != null) {
            for (Element schemaElement : ConfigurationReader.iterable(root.getElementsByTagName("schema"))) {
                SchemaSlotDescription slotDescription;
                Schema schema;
                Schema refinedSchema;
                Schema extendedSchema;
                Class type;
                String schemaName = ConfigurationReader.attr(schemaElement.getAttribute("name"));
                String typeName = ConfigurationReader.attr(schemaElement.getAttribute("type"));
                String extendedSchemaName = ConfigurationReader.attr(schemaElement.getAttribute("extends"));
                String refinedSchemaName = ConfigurationReader.attr(schemaElement.getAttribute("refines"));
                String schemaBundle = ConfigurationReader.attr(schemaElement.getAttribute("bundle"));
                String constructor = ConfigurationReader.attr(schemaElement.getAttribute("constructor"));
                if (RenderKit.getInstance().hasSchema(schemaName)) {
                    logger.error("Schema '{}' was already defined. Ignoring re-declaration.", (Object)schemaName);
                    continue;
                }
                try {
                    type = ConfigurationReader.getClassForType(typeName, true);
                }
                catch (ClassNotFoundException e) {
                    logger.error("schema '" + schemaName + "' was defined for the undefined type '" + typeName + "'. Ignoring it.", (Throwable)e);
                    continue;
                }
                if (extendedSchemaName != null && refinedSchemaName != null) {
                    logger.error("schema '" + schemaName + "' cannot extend '" + extendedSchemaName + "' and refine '" + refinedSchemaName + "' at the same time. Ignoring it.");
                    continue;
                }
                try {
                    extendedSchema = RenderKit.getInstance().findSchema(extendedSchemaName);
                }
                catch (NoSuchSchemaException e) {
                    logger.error("schema '" + schemaName + "' cannot extend '" + extendedSchemaName + "', schema not found. Ignoring it.", (Throwable)e);
                    continue;
                }
                try {
                    refinedSchema = RenderKit.getInstance().findSchema(refinedSchemaName);
                }
                catch (NoSuchSchemaException e) {
                    logger.error("schema '" + schemaName + "' cannot refine '" + refinedSchemaName + "', schema not found. Ignoring it.", (Throwable)e);
                    continue;
                }
                if (extendedSchema != null && !extendedSchema.getType().isAssignableFrom(type)) {
                    logger.warn("schema '{}' is defined for type '{}' that is not a subclass of the type '{}' specified in the extended schema", new Object[]{schemaName, typeName, extendedSchema.getType().getName()});
                }
                if (extendedSchema != null) {
                    schema = new Schema(schemaName, type, extendedSchema);
                } else if (refinedSchema != null) {
                    schema = refinedSchema;
                    schema.setType(type);
                } else {
                    schema = new Schema(schemaName, type);
                }
                NodeList removeElements = schemaElement.getElementsByTagName("remove");
                if (extendedSchemaName == null && refinedSchema == null && removeElements.getLength() > 0) {
                    logger.warn("schema '{}' specifies slots to be removed but it does not extend or refine schema", (Object)schemaName);
                } else {
                    for (Element element : ConfigurationReader.iterable(removeElements)) {
                        String name = element.getAttribute("name");
                        slotDescription = schema.getSlotDescription(name);
                        if (slotDescription == null) {
                            logger.warn("schema '{}' specifies that slot '{}' is to be removed but it is not defined in the extended schema", (Object)schemaName, (Object)name);
                            continue;
                        }
                        schema.removeSlotDescription(slotDescription);
                    }
                }
                for (Element element : ConfigurationReader.iterable(schemaElement.getElementsByTagName("slot"))) {
                    boolean hidden;
                    boolean required;
                    String slotName = ConfigurationReader.attr(element.getAttribute("name"));
                    String layout = ConfigurationReader.attr(element.getAttribute("layout"));
                    String key = ConfigurationReader.attr(element.getAttribute("key"));
                    String arg0 = ConfigurationReader.attr(element.getAttribute("arg0"));
                    String bundle = ConfigurationReader.attr(element.getAttribute("bundle"));
                    String slotSchema = ConfigurationReader.attr(element.getAttribute("schema"));
                    String validatorName = ConfigurationReader.attr(element.getAttribute("validator"));
                    String requiredValue = ConfigurationReader.attr(element.getAttribute("required"));
                    String defaultValue = ConfigurationReader.attr(element.getAttribute("default"));
                    String converterName = ConfigurationReader.attr(element.getAttribute("converter"));
                    String readOnlyValue = ConfigurationReader.attr(element.getAttribute("read-only"));
                    String hiddenValue = ConfigurationReader.attr(element.getAttribute("hidden"));
                    String helpLabelValue = ConfigurationReader.attr(element.getAttribute("help"));
                    String description = ConfigurationReader.attr(element.getAttribute("description"));
                    String descriptionFormat = ConfigurationReader.attr(element.getAttribute("descriptionFormat"));
                    Properties properties = ConfigurationReader.getPropertiesFromElement(element);
                    ArrayList<ValidatorProperties> validators = new ArrayList<ValidatorProperties>();
                    if (validatorName != null) {
                        try {
                            Class validator = ConfigurationReader.getClassForType(validatorName, true);
                            validators.add(new ValidatorProperties(validator, new Properties()));
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("in schema '" + schemaName + "': validator '" + validatorName + "' was not found. Ignoring slot declaration.", (Throwable)e);
                            continue;
                        }
                    }
                    boolean bl = required = requiredValue == null ? false : Boolean.parseBoolean(requiredValue);
                    if (required) {
                        Class<RequiredValidator> validator = RequiredValidator.class;
                        validators.add(new ValidatorProperties(validator, new Properties()));
                    }
                    for (Element validatorElement : ConfigurationReader.iterable(element.getElementsByTagName("validator"))) {
                        Properties validatorProperties = ConfigurationReader.getPropertiesFromElement(validatorElement);
                        validatorName = ConfigurationReader.attr(validatorElement.getAttribute("class"));
                        Class validator = null;
                        if (validatorName != null) {
                            try {
                                validator = ConfigurationReader.getClassForType(validatorName, true);
                            }
                            catch (ClassNotFoundException e) {
                                logger.error("in schema '" + schemaName + "': validator '" + validatorName + "' was not found. Ignoring validator declaration.", (Throwable)e);
                                continue;
                            }
                        }
                        validators.add(new ValidatorProperties(validator, validatorProperties));
                    }
                    Class converter = null;
                    if (converterName != null) {
                        try {
                            converter = ConfigurationReader.getClassForType(converterName, true);
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("in schema '" + schemaName + "': converter '" + converterName + "' was not found. Ignoring slot", (Throwable)e);
                            continue;
                        }
                    }
                    boolean readOnly = readOnlyValue == null ? false : Boolean.parseBoolean(readOnlyValue);
                    boolean bl2 = hidden = hiddenValue == null ? false : Boolean.parseBoolean(hiddenValue);
                    if (bundle == null) {
                        bundle = schemaBundle;
                    }
                    SchemaSlotDescription slotDescription2 = new SchemaSlotDescription(slotName);
                    slotDescription2.setLayout(layout);
                    slotDescription2.setKey(key);
                    slotDescription2.setArg0(arg0);
                    slotDescription2.setBundle(bundle);
                    slotDescription2.setProperties(properties);
                    slotDescription2.setSchema(slotSchema);
                    slotDescription2.setValidators(validators);
                    slotDescription2.setConverter(converter);
                    slotDescription2.setDefaultValue(defaultValue);
                    slotDescription2.setReadOnly(readOnly);
                    slotDescription2.setHidden(hidden);
                    slotDescription2.setHelpLabel(helpLabelValue);
                    slotDescription2.setDescription(description);
                    slotDescription2.setDescriptionFormat(descriptionFormat);
                    schema.addSlotDescription(slotDescription2);
                }
                Signature construtorSignature = null;
                if (constructor != null && (construtorSignature = ConfigurationReader.parseSignature(schema, constructor)) != null) {
                    for (SignatureParameter parameter : construtorSignature.getParameters()) {
                        slotDescription = parameter.getSlotDescription();
                        if (parameter.getSlotDescription() == null) continue;
                        slotDescription.setSetterIgnored(true);
                    }
                }
                schema.setConstructor(construtorSignature);
                NodeList nodeList = schemaElement.getElementsByTagName("setter");
                if (nodeList.getLength() > 0) {
                    schema.getSpecialSetters().clear();
                }
                for (Element setterElement : ConfigurationReader.iterable(nodeList)) {
                    String signature = setterElement.getAttribute("signature");
                    Signature setterSignature = ConfigurationReader.parseSignature(schema, signature);
                    if (setterSignature == null) continue;
                    for (SignatureParameter parameter : setterSignature.getParameters()) {
                        parameter.getSlotDescription().setSetterIgnored(true);
                    }
                    schema.addSpecialSetter(setterSignature);
                }
                if (refinedSchema != null) {
                    schema = new Schema(schemaName, type, refinedSchema);
                    schema.setConstructor(refinedSchema.getConstructor());
                }
                logger.debug("Registered new schema '{}' for type '{}'", (Object)schema.getName(), (Object)typeName);
                RenderKit.getInstance().registerSchema(schema);
            }
        }
    }

    private static Signature parseSignature(Schema schema, String signature) {
        String[] allParameters;
        String parameters;
        String name;
        int indexOfStartParent = signature.indexOf("(");
        if (indexOfStartParent != -1) {
            name = signature.substring(0, indexOfStartParent).trim();
            int indexOfCloseParen = signature.indexOf(")", indexOfStartParent);
            if (indexOfCloseParen == -1) {
                logger.error("in schema {}: malformed signature '{}', missing ')'", (Object)schema.getName(), (Object)signature);
                return null;
            }
            parameters = signature.substring(indexOfStartParent + 1, indexOfCloseParen);
        } else {
            name = null;
            parameters = signature.trim();
        }
        Signature programmaticSignature = new Signature(name);
        if (parameters.trim().length() == 0) {
            return programmaticSignature;
        }
        for (String allParameter : allParameters = parameters.split(",")) {
            Class slotType;
            String typeName;
            String slotName;
            String singleParameter = allParameter.trim();
            int index = singleParameter.indexOf(":");
            if (index != -1) {
                slotName = singleParameter.substring(0, index).trim();
                typeName = singleParameter.substring(index + 1).trim();
            } else {
                slotName = singleParameter;
                typeName = null;
            }
            SchemaSlotDescription slotDescription = schema.getSlotDescription(slotName);
            if (slotDescription == null) {
                logger.error("in schema {}: malformed signature '{}', slot '{}' is not defined", new Object[]{schema.getName(), signature, slotName});
            }
            if (typeName != null) {
                try {
                    slotType = ConfigurationReader.getClassForType(typeName, false);
                }
                catch (ClassNotFoundException e) {
                    logger.error("in schema " + schema.getName() + ": malformed signature '" + signature + "', could not find type '" + typeName + "'", (Throwable)e);
                    return null;
                }
            } else {
                slotType = RendererPropertyUtils.getPropertyType(schema.getType(), slotName);
            }
            programmaticSignature.addParameter(slotDescription, slotType);
        }
        return programmaticSignature;
    }

    private static Properties getPropertiesFromElement(Element element) {
        Properties properties = new Properties();
        for (Element propertyElement : ConfigurationReader.iterable(element.getElementsByTagName("property"))) {
            String name = ConfigurationReader.attr(propertyElement.getAttribute("name"));
            String value = ConfigurationReader.attr(propertyElement.getAttribute("value"));
            if (value == null && !propertyElement.getTextContent().isEmpty()) {
                value = propertyElement.getTextContent();
            }
            if (value == null) continue;
            properties.setProperty(name, value);
        }
        return properties;
    }

    public static void readRenderers(URL renderConfig, ServletContext ctx) throws ServletException {
        Document root = ConfigurationReader.readConfigRootElement(renderConfig, ctx);
        if (root != null) {
            NodeList renderers = root.getElementsByTagName("renderer");
            for (Element rendererElement : ConfigurationReader.iterable(renderers)) {
                String type = ConfigurationReader.attr(rendererElement.getAttribute("type"));
                String layout = ConfigurationReader.attr(rendererElement.getAttribute("layout"));
                String className = ConfigurationReader.attr(rendererElement.getAttribute("class"));
                Properties rendererProperties = ConfigurationReader.getPropertiesFromElement(rendererElement);
                try {
                    RenderMode mode;
                    Class objectClass = ConfigurationReader.getClassForType(type, true);
                    Class<?> rendererClass = Class.forName(className);
                    String modeName = ConfigurationReader.attr(rendererElement.getAttribute("mode"));
                    if (modeName == null) {
                        modeName = "output";
                    }
                    if (ConfigurationReader.hasRenderer(layout, objectClass, mode = RenderMode.valueOf(modeName.toUpperCase()))) {
                        logger.warn("[{}] Duplicated renderer definition for type {} and layout '{}'", new Object[]{modeName, objectClass, layout});
                    }
                    logger.debug("[{}] adding new renderer: {}/{}/{}/{}", new Object[]{modeName, objectClass, layout, rendererClass, rendererProperties});
                    RenderKit.getInstance().registerRenderer(mode, objectClass, layout, rendererClass, rendererProperties);
                }
                catch (ClassNotFoundException e) {
                    logger.error("Could not register renderer for type '" + type + "', class not found", (Throwable)e);
                }
            }
        }
    }

    private static String attr(String value) {
        return value.isEmpty() ? null : value;
    }

    private static Iterable<Element> iterable(final NodeList nodes) {
        return () -> new Iterator<Element>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < nodes.getLength();
            }

            @Override
            public Element next() {
                return (Element)nodes.item(this.i++);
            }
        };
    }

    private static boolean hasRenderer(String layout, Class objectClass, RenderMode mode) {
        try {
            return RenderKit.getInstance().getExactRendererDescription(mode, objectClass, layout) != null;
        }
        catch (NoRendererException e) {
            return false;
        }
    }

    private static Class getClassForType(String type, boolean prefixedLangPackage) throws ClassNotFoundException {
        String[] primitiveTypesNames = new String[]{"void", "boolean", "byte", "short", "int", "long", "char", "float", "double"};
        Class[] primitiveTypesClass = new Class[]{Void.TYPE, Boolean.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Character.TYPE, Float.TYPE, Double.TYPE};
        for (int i = 0; i < primitiveTypesNames.length; ++i) {
            if (!type.equals(primitiveTypesNames[i])) continue;
            return primitiveTypesClass[i];
        }
        if (!prefixedLangPackage && type.indexOf(".") == -1) {
            return Class.forName("java.lang." + type);
        }
        return Class.forName(type);
    }

    private static Document readConfigRootElement(URL config, ServletContext ctx) throws ServletException {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setEntityResolver((publicId, systemId) -> {
                InputStream stream = ctx.getResourceAsStream("/WEB-INF" + new URL(systemId).getPath());
                if (stream == null) {
                    logger.error("Could not read entity {}", (Object)systemId);
                    return null;
                }
                return new InputSource(stream);
            });
            return dBuilder.parse(config.openStream());
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public static void readAll(ServletContext context) throws ServletException {
        RenderKit.reset();
        try {
            for (Project project : FenixFramework.getProject().getProjects()) {
                URL schemaConfig;
                URL renderConfig = context.getResource("/WEB-INF/" + project.getName() + "/renderers-config.xml");
                if (renderConfig != null) {
                    ConfigurationReader.readRenderers(renderConfig, context);
                }
                if ((schemaConfig = context.getResource("/WEB-INF/" + project.getName() + "/schemas-config.xml")) == null) continue;
                ConfigurationReader.readSchemas(schemaConfig, context);
            }
        }
        catch (IOException e) {
            throw new ServletException((Throwable)e);
        }
    }
}

