/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.components.state;

import com.google.common.base.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlFormComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.Controllable;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.state.ConversionMessage;
import pt.ist.fenixWebFramework.renderers.components.state.EditRequest;
import pt.ist.fenixWebFramework.renderers.components.state.HiddenSlot;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.components.state.ValidationMessage;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.components.state.ViewStateWrapper;
import pt.ist.fenixWebFramework.renderers.contexts.InputContext;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectCollection;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class ComponentLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(ComponentLifeCycle.class);
    private static ComponentLifeCycle instance = new ComponentLifeCycle();

    public static ComponentLifeCycle getInstance() {
        return instance;
    }

    public static ViewDestination execute(HttpServletRequest request) throws Exception {
        return instance.doLifeCycle(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewDestination doLifeCycle(HttpServletRequest request) throws Exception {
        ViewDestination destination;
        EditRequest editRequest = new EditRequest(request);
        List<IViewState> viewStates = editRequest.getAllViewStates();
        ArrayList<ViewStateHolder> viewStateHolders = new ArrayList<ViewStateHolder>();
        boolean allValid = true;
        boolean anySkip = false;
        boolean anyCanceled = false;
        boolean skipValidation = false;
        skipValidation = Boolean.parseBoolean(request.getParameter("skipValidation"));
        for (IViewState viewState : viewStates) {
            ViewStateHolder holder = new ViewStateHolder(viewState);
            viewStateHolders.add(holder);
            if (this.cancelRequested(editRequest)) {
                ComponentLifeCycle.doCancel(viewState);
                anyCanceled = true;
                holder.setCanceled(true);
                continue;
            }
            HtmlComponent component = this.restoreComponent(viewState);
            viewState.setValid(true);
            viewState.setSkipUpdate(false);
            viewState.setSkipValidation(false);
            viewState.setCurrentDestination((ViewDestination)null);
            ComponentCollector collector = null;
            viewState.setUpdateComponentTree(true);
            while (viewState.getUpdateComponentTree()) {
                viewState.setUpdateComponentTree(false);
                collector = new ComponentCollector(viewState, component);
                this.updateComponent(collector, editRequest);
                this.runControllers(collector, viewState);
                component = viewState.getComponent();
            }
            holder.setComponent(component);
            holder.setCollector(collector);
            skipValidation = skipValidation || viewState.skipValidation();
        }
        for (ViewStateHolder holder : viewStateHolders) {
            if (holder.isCanceled()) continue;
            IViewState viewState = holder.getViewState();
            if (viewState.isVisible() && !viewState.skipUpdate() && !skipValidation) {
                viewState.setValid(this.validateComponent(viewState, holder.getComponent(), viewState.getMetaObject()));
            }
            if ((viewState.isVisible() || this.isHiddenSlot(viewState)) && viewState.isValid()) {
                viewState.setValid(this.updateMetaObject(holder.getCollector(), editRequest, viewState));
            }
            allValid = allValid && viewState.isValid();
            anySkip = anySkip || viewState.skipUpdate();
        }
        try {
            if (allValid && !anySkip && !anyCanceled) {
                this.updateDomain(viewStates);
            }
        }
        finally {
            destination = this.getDestination(viewStates);
            this.prepareDestination(viewStates, (HttpServletRequest)editRequest);
        }
        return destination;
    }

    public static void doCancel(IViewState viewState) {
        viewState.setCurrentDestination("cancel");
        viewState.cancel();
    }

    private boolean cancelRequested(EditRequest editRequest) {
        return editRequest.getParameter("pt.ist.fenixWebFramework.renderers.CANCEL") != null || editRequest.getAttribute("pt.ist.fenixWebFramework.renderers.CANCEL") != null;
    }

    private boolean isHiddenSlot(IViewState viewState) {
        return viewState.getMetaObject() instanceof MetaSlot && viewState.getHiddenSlots().size() > 0;
    }

    private ViewDestination getDestination(List<IViewState> viewStates) {
        ViewDestination destination = null;
        for (IViewState viewState : viewStates) {
            if (!viewState.isVisible() && viewStates.size() > 1) continue;
            if (viewState.isCanceled()) {
                destination = viewState.getCurrentDestination();
            } else if (viewState.skipUpdate()) {
                destination = viewState.getCurrentDestination();
                if (destination == null) {
                    destination = viewState.getDestination("input");
                }
                if (destination == null) {
                    destination = viewState.getInputDestination();
                }
            } else {
                destination = viewState.getCurrentDestination();
                if (destination == null) {
                    destination = viewState.getDestination(viewState.isValid() ? "success" : "invalid");
                }
                if (destination == null && !viewState.isValid() && (destination = viewState.getDestination("input")) == null) {
                    destination = viewState.getInputDestination();
                }
            }
            if (destination == null) continue;
            break;
        }
        return destination;
    }

    private boolean validateComponent(IViewState viewState, HtmlComponent component, MetaObject metaObject) {
        MetaSlot slot;
        MetaSlotKey key;
        boolean valid = true;
        List<HtmlComponent> validators = component.getChildren(new Predicate<HtmlComponent>(){

            public boolean apply(HtmlComponent component) {
                return component instanceof HtmlChainValidator;
            }
        });
        List<HtmlComponent> formComponents = HtmlComponent.getComponents(component, new Predicate<HtmlComponent>(){

            public boolean apply(HtmlComponent component) {
                if (!(component instanceof HtmlFormComponent)) {
                    return false;
                }
                HtmlFormComponent formComponent = (HtmlFormComponent)component;
                return formComponent.getTargetSlot() != null;
            }
        });
        if (!formComponents.isEmpty()) {
            for (HtmlComponent boundComponent : formComponents) {
                HtmlFormComponent formComponent = (HtmlFormComponent)boundComponent;
                HtmlChainValidator chainValidator = formComponent.getChainValidator();
                if (chainValidator == null) {
                    chainValidator = new HtmlChainValidator(formComponent);
                }
                key = formComponent.getTargetSlot();
                slot = this.getMetaSlot(metaObject, key);
                for (HtmlValidator validator : slot.getValidatorsList()) {
                    chainValidator.addValidator(validator);
                }
                validators.add(chainValidator);
            }
        }
        for (HtmlComponent validator : validators) {
            HtmlChainValidator htmlValidator = (HtmlChainValidator)validator;
            htmlValidator.performValidation();
            boolean bl = valid = valid && htmlValidator.isValid();
            if (htmlValidator.isValid()) continue;
            if (metaObject instanceof MetaSlot) {
                viewState.addMessage(new ValidationMessage((MetaSlot)metaObject, htmlValidator.getErrorMessage()));
                continue;
            }
            HtmlFormComponent validatedFormComponent = (HtmlFormComponent)htmlValidator.getComponent();
            key = validatedFormComponent.getTargetSlot();
            if (key == null || (slot = this.getMetaSlot(metaObject, key)) == null) continue;
            viewState.addMessage(new ValidationMessage(slot, htmlValidator.getErrorMessage()));
        }
        return valid;
    }

    private void runControllers(ComponentCollector collector, IViewState viewState) {
        for (HtmlController controller : collector.getControllers()) {
            HtmlFormComponent formComponent = (HtmlFormComponent)controller.getControlledComponent();
            if (formComponent != null) {
                controller.execute(new ViewStateWrapper(viewState, formComponent.getName()));
                continue;
            }
            controller.execute(viewState);
        }
    }

    public void prepareDestination(List<IViewState> viewStates, HttpServletRequest request) throws IOException, ClassNotFoundException {
        request.setAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME, viewStates);
    }

    public HtmlComponent restoreComponent(IViewState viewState) throws InstantiationException, IllegalAccessException {
        viewState.setPostBack(true);
        MetaObject metaObject = viewState.getMetaObject();
        if (metaObject == null) {
            viewState.setMetaObject(MetaObjectFactory.createObject(null, null));
            metaObject = viewState.getMetaObject();
        }
        metaObject.setUser(viewState.getUser());
        String layout = viewState.getLayout();
        Properties properties = viewState.getProperties();
        InputContext context = new InputContext();
        context.setLayout(layout);
        context.setProperties(properties);
        context.setViewState(viewState);
        viewState.setContext(context);
        if (!viewState.isVisible()) {
            return new HtmlText();
        }
        if (this.isHiddenSlot(viewState)) {
            viewState.setComponent(new HtmlText());
        } else {
            Object object = metaObject.getObject();
            viewState.setComponent(RenderKit.getInstance().render(context, object, metaObject.getType()));
        }
        HtmlComponent component = viewState.getComponent();
        return component != null ? component : new HtmlText();
    }

    private void updateComponent(ComponentCollector collector, EditRequest editRequest) {
        List<HtmlFormComponent> formComponents = collector.getFormComponents();
        for (HtmlFormComponent formComponent : formComponents) {
            String name = formComponent.getName();
            if (formComponent instanceof HtmlMultipleValueComponent) {
                String[] values = editRequest.getParameterValues(name);
                if (values == null) {
                    values = new String[]{};
                }
                ((HtmlMultipleValueComponent)formComponent).setValues(values);
                continue;
            }
            if (!(formComponent instanceof HtmlSimpleValueComponent)) continue;
            String value = editRequest.getParameter(name);
            ((HtmlSimpleValueComponent)formComponent).setValue(value);
        }
    }

    private void updateDomain(List<IViewState> viewStates) {
        ArrayList<MetaObject> metaObjectsToCommit = new ArrayList<MetaObject>();
        MetaObjectCollection metaObjectCollection = new MetaObjectCollection();
        for (IViewState state : viewStates) {
            MetaObject metaObject = state.getMetaObject();
            if (metaObject instanceof MetaSlot) {
                metaObject = ((MetaSlot)metaObject).getMetaObject();
            }
            if (!metaObjectsToCommit.contains(metaObject)) {
                metaObjectsToCommit.add(metaObject);
            }
            metaObjectCollection.setUser(state.getUser());
        }
        for (MetaObject object : metaObjectsToCommit) {
            metaObjectCollection.add(object);
        }
        metaObjectCollection.commitChanges();
    }

    private boolean updateMetaObject(ComponentCollector collector, EditRequest editRequest, IViewState viewState) throws Exception {
        boolean hasConvertError = false;
        List<HtmlFormComponent> formComponents = collector.getFormComponents();
        for (HtmlFormComponent formComponent : formComponents) {
            MetaSlot metaSlot;
            MetaSlotKey targetSlot = formComponent.getTargetSlot();
            if (targetSlot == null || (metaSlot = this.getMetaSlot(viewState.getMetaObject(), targetSlot)) == null || metaSlot.isReadOnly()) continue;
            try {
                Object finalValue = formComponent.getConvertedValue(metaSlot);
                metaSlot.setObject(finalValue);
            }
            catch (Exception e) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Failed to convert slot " + metaSlot.getName(), (Throwable)e);
                }
                this.addConvertError(viewState, metaSlot, e);
                hasConvertError = true;
            }
        }
        return !hasConvertError;
    }

    private MetaSlot getMetaSlot(MetaObject metaObject, MetaSlotKey targetSlot) {
        if (metaObject instanceof MetaSlot) {
            if (metaObject.getKey().equals(targetSlot)) {
                return (MetaSlot)metaObject;
            }
            metaObject = ((MetaSlot)metaObject).getMetaObject();
        }
        for (MetaSlot slot : metaObject.getAllSlots()) {
            if (!slot.getKey().equals(targetSlot)) continue;
            return slot;
        }
        return null;
    }

    private void addConvertError(IViewState viewState, MetaSlot metaSlot, Exception exception) {
        viewState.addMessage(new ConversionMessage(metaSlot, exception.getLocalizedMessage()));
    }

    private static class ViewStateHolder {
        private IViewState viewState;
        private HtmlComponent component;
        private ComponentCollector collector;
        private boolean canceled;

        public ViewStateHolder(IViewState viewState) {
            this.viewState = viewState;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public void setCanceled(boolean canceled) {
            this.canceled = canceled;
        }

        public HtmlComponent getComponent() {
            return this.component;
        }

        public ComponentCollector getCollector() {
            return this.collector;
        }

        public IViewState getViewState() {
            return this.viewState;
        }

        public void setViewState(IViewState viewState) {
            this.viewState = viewState;
        }

        public void setComponent(HtmlComponent component) {
            this.component = component;
        }

        public void setCollector(ComponentCollector collector) {
            this.collector = collector;
        }
    }

    private class ComponentCollector {
        private final List<HtmlFormComponent> formComponents = new ArrayList<HtmlFormComponent>();
        private final List<HtmlController> controllers = new ArrayList<HtmlController>();

        public ComponentCollector(IViewState viewState, HtmlComponent component) {
            if (component != null) {
                this.collect(component);
                InputContext context = viewState.getContext();
                if (context != null) {
                    this.collect(context.getForm().getSubmitButton());
                    this.collect(context.getForm().getCancelButton());
                }
                this.addHiddenComponents(viewState);
            }
        }

        private void addHiddenComponents(IViewState viewState) {
            for (HiddenSlot hiddenSlot : viewState.getHiddenSlots()) {
                HtmlFormComponent hiddenField = hiddenSlot.isMultiple() ? new HtmlMultipleHiddenField(hiddenSlot.getName()) : new HtmlHiddenField(hiddenSlot.getName(), null);
                hiddenField.setTargetSlot(hiddenSlot.getKey());
                this.formComponents.add(hiddenField);
            }
        }

        public List<HtmlFormComponent> getFormComponents() {
            return this.formComponents;
        }

        public List<HtmlController> getControllers() {
            return this.controllers;
        }

        private void collect(HtmlComponent component) {
            Predicate<HtmlComponent> isFormComponent = new Predicate<HtmlComponent>(){

                public boolean apply(HtmlComponent component) {
                    HtmlFormComponent formComponent;
                    return component instanceof HtmlFormComponent && (formComponent = (HtmlFormComponent)component).getName() != null;
                }
            };
            List<HtmlComponent> components = HtmlFormComponent.getComponents(component, isFormComponent);
            for (HtmlComponent comp : components) {
                this.formComponents.add((HtmlFormComponent)comp);
            }
            Predicate<HtmlComponent> hasController = new Predicate<HtmlComponent>(){

                public boolean apply(HtmlComponent component) {
                    Controllable controllabelComponent;
                    return component instanceof Controllable && (controllabelComponent = (Controllable)((Object)component)).hasController();
                }
            };
            components = HtmlFormComponent.getComponents(component, hasController);
            for (HtmlComponent comp : components) {
                this.controllers.add(((Controllable)((Object)comp)).getController());
            }
        }
    }
}

