/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.Message;
import pt.ist.fenixWebFramework.renderers.taglib.HasMessagesTag;

public class MessagesTag
extends BodyTagSupport {
    private static final Logger logger = LoggerFactory.getLogger(MessagesTag.class);
    private Iterator<Message> iterator;
    private Message message;
    private String forName;
    private String type;

    public String getFor() {
        return this.forName;
    }

    public void setFor(String forName) {
        this.forName = forName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void release() {
        super.release();
        this.iterator = null;
        this.message = null;
        this.forName = null;
    }

    public int doStartTag() throws JspException {
        IViewState viewState = HasMessagesTag.getViewStateWithId(this.pageContext, this.getViewStateId());
        if (viewState == null) {
            return 0;
        }
        this.iterator = this.getMessagesIterator(viewState, this.getType());
        return this.goNext(true);
    }

    private Iterator<Message> getMessagesIterator(IViewState viewState, String type) {
        Message.Type messageType = this.getMessageType();
        if (messageType == null) {
            return viewState.getMessages().iterator();
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        for (Message message : viewState.getMessages()) {
            if (!messageType.equals((Object)message.getType())) continue;
            messages.add(message);
        }
        return messages.iterator();
    }

    public Message.Type getMessageType() {
        HasMessagesTag parent = (HasMessagesTag)MessagesTag.findAncestorWithClass((Tag)this, HasMessagesTag.class);
        if (this.getType() != null) {
            if (parent != null && parent.getMessageType() != null) {
                logger.warn("parent 'hasMessage' tag is beeing ignored since the 'type' attribute was specified");
            }
            return Message.Type.valueOf(this.getType().toUpperCase());
        }
        if (parent != null) {
            return parent.getMessageType();
        }
        return null;
    }

    private String getViewStateId() {
        HasMessagesTag parent = (HasMessagesTag)MessagesTag.findAncestorWithClass((Tag)this, HasMessagesTag.class);
        if (this.getFor() != null) {
            if (parent != null) {
                logger.warn("parent 'hasMessages' tag is beeing ignore since 'for' attribute was specified");
            }
            return this.getFor();
        }
        if (parent == null) {
            return null;
        }
        return parent.getFor();
    }

    private int goNext(boolean starting) {
        if (!this.iterator.hasNext()) {
            return 0;
        }
        this.setCurrentMessage(this.iterator.next());
        if (starting) {
            return 1;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        try {
            BodyContent body = this.getBodyContent();
            if (body != null) {
                JspWriter out = body.getEnclosingWriter();
                out.println(body.getString());
                body.clearBody();
            }
        }
        catch (IOException e) {
            throw new JspException("could not write body", (Throwable)e);
        }
        return this.goNext(false);
    }

    public int doEndTag() throws JspException {
        this.iterator = null;
        this.message = null;
        return 6;
    }

    private void setCurrentMessage(Message message) {
        this.message = message;
    }

    public Message getCurrentMessage() {
        return this.message;
    }
}

