/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.taglib;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import pt.ist.fenixWebFramework.renderers.taglib.BaseRenderObjectTag;
import pt.ist.fenixWebFramework.renderers.taglib.CreateObjectTag;

public class DefaultValueTag
extends TagSupport {
    private String slot;
    private String name;
    private String property;
    private String scope;
    private String value;
    private String converter;

    public String getConverter() {
        return this.converter;
    }

    public void setConverter(String converter) {
        this.converter = converter;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getSlot() {
        return this.slot;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void release() {
        super.release();
        this.slot = null;
        this.name = null;
        this.property = null;
        this.scope = null;
        this.value = null;
        this.converter = null;
    }

    public int doStartTag() throws JspException {
        this.validateAttributes();
        CreateObjectTag parent = this.getParentCreateTag();
        if (parent == null) {
            throw new JspException("the default value tag can only be used inside a create tag");
        }
        parent.setDefaultValue(this.findSlot(), this.findObject(), this.getConverterClass());
        return 0;
    }

    private String findSlot() {
        String slot = this.getSlot();
        if (slot == null) {
            slot = this.getParentCreateTag().getSlot();
        }
        if (slot == null) {
            throw new RuntimeException("you must define the slot attribute or have a parent create tag with a slot defined");
        }
        return slot;
    }

    protected void validateAttributes() throws JspException {
        if (this.getName() == null && this.getValue() == null) {
            throw new JspException("you must define either the 'name' or 'value' attributes");
        }
        if (this.getName() == null && this.getProperty() != null) {
            throw new JspException("you must define the 'name' attribute to use the 'property' attribute");
        }
        if (this.getName() == null && this.getScope() != null) {
            throw new JspException("you must define the 'name' attribute to use the 'scope' attribute");
        }
        if (this.getName() != null && this.getValue() != null) {
            throw new JspException("you can't define both the 'name' and 'value' attributes");
        }
        if (this.getName() != null && this.getConverter() != null) {
            throw new JspException("you can't define both the 'name' and 'converter' attributes, converter is to be used with the 'value' attribute only");
        }
    }

    protected CreateObjectTag getParentCreateTag() {
        return (CreateObjectTag)DefaultValueTag.findAncestorWithClass((Tag)this, CreateObjectTag.class);
    }

    public int doEndTag() throws JspException {
        return 6;
    }

    protected Object findObject() throws JspException {
        if (this.getName() == null) {
            return this.getValue();
        }
        return BaseRenderObjectTag.lookup(this.pageContext, this.getName(), this.getProperty(), this.getScope());
    }

    protected Class getConverterClass() throws JspException {
        if (this.getConverter() == null) {
            return null;
        }
        try {
            String converterName = this.getConverter();
            return Class.forName(converterName);
        }
        catch (ClassNotFoundException e) {
            throw new JspException("converter class '" + this.getConverter() + "' could not be found");
        }
    }
}

