/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlLinkWithPreprendedComment;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.state.ViewDestination;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class ObjectLinkRenderer
extends OutputRenderer {
    private boolean useParent;
    private String linkFormat;
    private boolean contextRelative;
    private boolean moduleRelative;
    private String destination;
    private String subSchema;
    private String subLayout;
    private String key;
    private String bundle;
    private String text;
    private String linkIf;
    private boolean blankTarget = false;
    private boolean indentation = false;
    private final boolean hasContext = false;
    private boolean hasChecksum = true;
    private String format;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isBlankTarget() {
        return this.blankTarget;
    }

    public void setBlankTarget(boolean blankTarget) {
        this.blankTarget = blankTarget;
    }

    public String getLinkFormat() {
        return this.linkFormat;
    }

    public void setLinkFormat(String linkFormat) {
        this.linkFormat = linkFormat;
    }

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public boolean isModuleRelative() {
        return this.moduleRelative;
    }

    public void setModuleRelative(boolean moduleRelative) {
        this.moduleRelative = moduleRelative;
    }

    public boolean isUseParent() {
        return this.useParent;
    }

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getSubLayout() {
        return this.subLayout;
    }

    public void setSubLayout(String subLayout) {
        this.subLayout = subLayout;
    }

    public String getSubSchema() {
        return this.subSchema;
    }

    public void setSubSchema(String subSchema) {
        this.subSchema = subSchema;
    }

    public String getLinkIf() {
        return this.linkIf;
    }

    public void setLinkIf(String linkIf) {
        this.linkIf = linkIf;
    }

    public void setIndentation(boolean indentation) {
        this.indentation = indentation;
    }

    public boolean isIndentation() {
        return this.indentation;
    }

    public boolean getHasChecksum() {
        return this.hasChecksum;
    }

    public void setHasChecksum(boolean hasChecksum) {
        this.hasChecksum = hasChecksum;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Object usedObject = ObjectLinkRenderer.this.getTargetObject(object);
                if (usedObject == null) {
                    return new HtmlText();
                }
                if (this.isAllowedToLink(usedObject)) {
                    HtmlLink link = this.getLink(usedObject);
                    link.setIndented(ObjectLinkRenderer.this.isIndentation());
                    String text = this.getLinkText();
                    if (text != null) {
                        link.setText(text);
                    } else if (ObjectLinkRenderer.this.getFormat() != null) {
                        link.setText(RenderUtils.getFormattedProperties(ObjectLinkRenderer.this.getFormat(), usedObject));
                    } else {
                        link.setBody(this.getLinkBody(object));
                    }
                    if (ObjectLinkRenderer.this.isBlankTarget()) {
                        link.setTarget("_blank");
                    }
                    return link;
                }
                return this.getLinkBody(object);
            }

            private boolean isAllowedToLink(Object usedObject) {
                if (ObjectLinkRenderer.this.getLinkIf() == null) {
                    return true;
                }
                try {
                    Object object = PropertyUtils.getProperty((Object)usedObject, (String)ObjectLinkRenderer.this.getLinkIf());
                    if (object == null) {
                        return true;
                    }
                    return (Boolean)object;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            public HtmlComponent getLinkBody(Object object) {
                Schema findSchema = RenderKit.getInstance().findSchema(ObjectLinkRenderer.this.getSubSchema());
                return ObjectLinkRenderer.this.renderValue(object, findSchema, ObjectLinkRenderer.this.getSubLayout());
            }

            private String getLinkText() {
                if (ObjectLinkRenderer.this.getText() != null) {
                    return ObjectLinkRenderer.this.getText();
                }
                if (ObjectLinkRenderer.this.getKey() == null) {
                    return null;
                }
                return RenderUtils.getResourceString(ObjectLinkRenderer.this.getBundle(), ObjectLinkRenderer.this.getKey());
            }

            private HtmlLink getLink(Object usedObject) {
                String url;
                HtmlLink link;
                HtmlLink htmlLink = link = !ObjectLinkRenderer.this.getHasChecksum() ? new HtmlLinkWithPreprendedComment("<!-- NO_CHECKSUM -->") : new HtmlLink();
                if (ObjectLinkRenderer.this.getDestination() != null) {
                    ViewDestination destination = ObjectLinkRenderer.this.getContext().getViewState().getDestination(ObjectLinkRenderer.this.getDestination());
                    if (destination != null) {
                        link.setModule(destination.getModule());
                        url = destination.getPath();
                    } else {
                        url = "#";
                    }
                } else {
                    url = ObjectLinkRenderer.this.getLinkFormat() != null ? ObjectLinkRenderer.this.getLinkFormat() : "#";
                }
                link.setUrl(RenderUtils.getFormattedProperties(url, usedObject));
                link.setModuleRelative(ObjectLinkRenderer.this.isModuleRelative());
                link.setContextRelative(ObjectLinkRenderer.this.isContextRelative());
                return link;
            }
        };
    }

    protected Object getTargetObject(Object object) {
        if (this.isUseParent()) {
            if (this.getContext().getParentContext() != null) {
                return this.getContext().getParentContext().getMetaObject().getObject();
            }
            return null;
        }
        return object;
    }
}

