/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class ClassAsLabelRenderer
extends OutputRenderer {
    private String bundle;
    private String labelFormat;
    private boolean escape = true;

    public String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public void setLabelFormat(String labelFormat) {
        this.labelFormat = labelFormat;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                if (type == null) {
                    return new HtmlText();
                }
                String labelName = this.getLabelName((Class)object);
                String label = RenderUtils.getResourceString(ClassAsLabelRenderer.this.getBundle(), labelName);
                return new HtmlText(label, ClassAsLabelRenderer.this.isEscape());
            }

            protected String getLabelName(Class targetClass) {
                if (ClassAsLabelRenderer.this.getLabelFormat() == null) {
                    return "label." + targetClass.getName();
                }
                return RenderUtils.getFormattedProperties(ClassAsLabelRenderer.this.getLabelFormat(), targetClass);
            }

            protected String getLabelName(String className) {
                return ClassAsLabelRenderer.this.getLabelFormat() == null ? "label." + className : this.getFormattedProperties(className);
            }

            protected String getFormattedProperties(Object object) {
                return RenderUtils.getFormattedProperties(ClassAsLabelRenderer.this.getLabelFormat(), object);
            }
        };
    }

    public boolean isEscape() {
        return this.escape;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }
}

