/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixWebFramework.servlets.filters.contentRewrite.GenericChecksumRewriter;

public class ImageObjectRenderer
extends OutputRenderer {
    private String imageFormat;
    private boolean useParent;
    private boolean moduleRelative;
    private boolean contextRelative;

    public boolean isContextRelative() {
        return this.contextRelative;
    }

    public void setContextRelative(boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public boolean isModuleRelative() {
        return this.moduleRelative;
    }

    public void setModuleRelative(boolean moduleRelative) {
        this.moduleRelative = moduleRelative;
    }

    public boolean isUseParent() {
        return this.useParent;
    }

    public void setUseParent(boolean useParent) {
        this.useParent = useParent;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new ImageObjectLayout();
    }

    public class ImageObjectLayout
    extends Layout {
        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            HtmlImage image = new HtmlImage();
            Object link = RenderUtils.getFormattedProperties(ImageObjectRenderer.this.getImageFormat(), this.getTargetObject(object));
            if (ImageObjectRenderer.this.isModuleRelative()) {
                link = RenderUtils.getModuleRelativePath("") + (String)link;
            } else if (ImageObjectRenderer.this.isContextRelative()) {
                link = RenderUtils.getContextRelativePath("") + (String)link;
            }
            if (((String)link).contains(".do")) {
                String checksum = GenericChecksumRewriter.calculateChecksum((String)link, ImageObjectRenderer.this.getContext().getViewState().getRequest().getSession(false));
                link = (String)link + (((String)link).contains("?") ? (char)'&' : '?') + "_request_checksum_=" + checksum;
            }
            image.setSource((String)link);
            return image;
        }

        protected Object getTargetObject(Object object) {
            if (ImageObjectRenderer.this.isUseParent()) {
                if (ImageObjectRenderer.this.getContext().getParentContext() != null) {
                    return ImageObjectRenderer.this.getContext().getParentContext().getMetaObject().getObject();
                }
                return null;
            }
            return object;
        }
    }
}

