/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyArrayConverter;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlActionLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlActionLinkController;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.contexts.PresentationContext;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.TabularLayout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;
import pt.ist.fenixWebFramework.renderers.model.MetaSlotKey;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;
import pt.ist.fenixWebFramework.renderers.utils.RenderMode;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class ManageableListRenderer
extends InputRenderer {
    public static final String MANAGED_SLOT_NAME = ManageableListRenderer.class.getName() + "/slot/name";
    public static final String MANAGED_SLOT_KEY = ManageableListRenderer.class.getName() + "/slot/key";
    private String destination;
    private String eachSchema;
    private String eachLayout;

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        MetaObject metaObject = this.getInputContext().getMetaObject();
        return new ManageableListLayout((Collection)metaObject.getObject());
    }

    private class ManageableListLayout
    extends TabularLayout {
        private final List objects;
        private final HtmlMultipleHiddenField hiddenValues;

        public ManageableListLayout(Collection collection) {
            this.objects = new ArrayList(collection);
            this.hiddenValues = new HtmlMultipleHiddenField();
            this.hiddenValues.setTargetSlot((MetaSlotKey)ManageableListRenderer.this.getInputContext().getMetaObject().getKey());
            this.hiddenValues.setConverter(new DomainObjectKeyArrayConverter());
        }

        @Override
        protected int getNumberOfColumns() {
            return 2;
        }

        @Override
        protected int getNumberOfRows() {
            return this.objects == null ? 0 : this.objects.size();
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            return null;
        }

        @Override
        public HtmlComponent createComponent(Object object, Class type) {
            HtmlComponent component = super.createComponent(object, type);
            HtmlBlockContainer container = new HtmlBlockContainer();
            container.addChild(component);
            container.addChild(this.hiddenValues);
            HtmlActionLink link = new HtmlActionLink();
            link.setName(ManageableListRenderer.this.getInputContext().getMetaObject().getKey().toString() + "/add");
            link.setText(RenderUtils.getResourceString("renderers.list.management.add"));
            link.setController(new FollowDestinationController((MetaSlot)ManageableListRenderer.this.getInputContext().getMetaObject()));
            container.addChild(link);
            return container;
        }

        @Override
        public void applyStyle(HtmlComponent component) {
            HtmlContainer container = (HtmlContainer)component;
            super.applyStyle(container.getChildren().get(0));
        }

        @Override
        protected HtmlComponent getComponent(int rowIndex, int columnIndex) {
            Object object = this.objects.get(rowIndex);
            Schema schema = RenderKit.getInstance().findSchema(ManageableListRenderer.this.getEachSchema());
            String layout = ManageableListRenderer.this.getEachLayout();
            MetaObject metaObject = MetaObjectFactory.createObject(object, schema);
            if (columnIndex == 0) {
                this.hiddenValues.addValue(metaObject.getKey().toString());
                PresentationContext newContext = ManageableListRenderer.this.getContext().createSubContext(metaObject);
                newContext.setLayout(layout);
                newContext.setRenderMode(RenderMode.OUTPUT);
                RenderKit kit = RenderKit.getInstance();
                return kit.render(newContext, object);
            }
            HtmlActionLink link = new HtmlActionLink();
            String prefix = ManageableListRenderer.this.getInputContext().getMetaObject().getKey().toString();
            link.setName(prefix + "/delete/" + rowIndex);
            link.setText(RenderUtils.getResourceString("renderers.list.management.delete"));
            HtmlTableRow row = this.getTable().getRows().get(rowIndex);
            link.setController(new RemoveLineController(this.getTable(), this.hiddenValues, row, prefix));
            return link;
        }
    }

    class FollowDestinationController
    extends HtmlActionLinkController {
        private final MetaSlot slot;

        public FollowDestinationController(MetaSlot slot) {
            this.slot = slot;
        }

        @Override
        public void linkPressed(IViewState viewState, HtmlActionLink link) {
            if (ManageableListRenderer.this.getDestination() != null) {
                viewState.setAttribute(MANAGED_SLOT_NAME, this.slot.getName());
                viewState.setAttribute(MANAGED_SLOT_KEY, this.slot.getKey());
                viewState.setCurrentDestination(ManageableListRenderer.this.getDestination());
            }
        }
    }

    class RemoveLineController
    extends HtmlActionLinkController {
        private final HtmlTable table;
        private final HtmlTableRow row;
        private final HtmlMultipleHiddenField values;
        private final String prefix;

        public RemoveLineController(HtmlTable table, HtmlMultipleHiddenField values, HtmlTableRow row, String prefix) {
            this.table = table;
            this.values = values;
            this.row = row;
            this.prefix = prefix;
        }

        @Override
        public void linkPressed(IViewState viewState, HtmlActionLink link) {
            int index = this.table.getRows().indexOf(this.row);
            this.table.removeRow(this.row);
            this.values.removeValue(index);
            this.renameLinks();
        }

        private void renameLinks() {
            List<HtmlComponent> links = this.table.getChildren(new Predicate<HtmlComponent>(){

                public boolean apply(HtmlComponent component) {
                    return component instanceof HtmlActionLink;
                }
            });
            int pos = 0;
            for (HtmlComponent component : links) {
                ((HtmlActionLink)component).setName(this.prefix + "/delete/" + pos++);
            }
        }
    }
}

