/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class StringLengthValidator
extends HtmlValidator {
    private Integer min;
    private Integer max;

    public StringLengthValidator() {
        this.setMessage("renderers.validator.invalid.length");
    }

    public StringLengthValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
        this.setMessage("renderers.validator.invalid.length");
    }

    @Override
    public void performValidation() {
        HtmlSimpleValueComponent component = (HtmlSimpleValueComponent)this.getComponent();
        String string = component.getValue();
        this.setValid(string.length() >= this.getMin() && (this.getMax() == null || string.length() <= this.getMax()));
    }

    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    @Override
    public boolean hasJavascriptSupport() {
        return true;
    }

    @Override
    protected String getSpecificValidatorScript() {
        return "function(element) { var text = $(element).attr('value');return text.length == 0 || (text.length >" + this.getMin() + (String)(this.getMax() != null ? " && text.length < " + this.getMax() : "") + ";}";
    }
}

