/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.layouts.TabularLayout;
import pt.ist.fenixWebFramework.renderers.model.MetaObject;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public class TabularNonNullValuesRenderer
extends OutputRenderer {
    private static int numberOfColumns = 2;
    private String label;
    private String schema;
    private String columnClasses;
    private String rowClasses;

    public String getRowClasses() {
        return this.rowClasses;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new TabularNonNullValuesLayout();
    }

    protected class TabularNonNullValuesLayout
    extends TabularLayout {
        private final MetaObject metaObject;
        private final List<MetaSlot> slots;
        private int indexSkipped = 0;

        public TabularNonNullValuesLayout() {
            this.metaObject = TabularNonNullValuesRenderer.this.getContext().getMetaObject();
            this.slots = this.metaObject.getSlots();
        }

        @Override
        protected boolean isHeader(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        protected HtmlComponent getComponent(int rowIndex, int columnIndex) {
            if (!this.renderRowIndex(rowIndex + this.indexSkipped)) {
                ++this.indexSkipped;
                return this.getComponent(rowIndex, columnIndex);
            }
            return columnIndex == 0 ? new HtmlText(this.addLabel(this.slots.get(rowIndex + this.indexSkipped).getLabel()), false) : TabularNonNullValuesRenderer.this.renderSlot(this.metaObject.getSlots().get(rowIndex + this.indexSkipped));
        }

        @Override
        protected HtmlComponent getHeaderComponent(int columnIndex) {
            return new HtmlText();
        }

        @Override
        protected int getNumberOfColumns() {
            return numberOfColumns;
        }

        @Override
        protected int getNumberOfRows() {
            int numberOfRows = 0;
            for (MetaSlot slot : this.metaObject.getSlots()) {
                if (!this.isValidObject(slot.getObject())) continue;
                ++numberOfRows;
            }
            return numberOfRows;
        }

        private boolean renderRowIndex(int rowIndex) {
            return this.isValidObject(this.metaObject.getSlots().get(rowIndex).getObject());
        }

        private String addLabel(String name) {
            return TabularNonNullValuesRenderer.this.getLabel() == null ? name + ":" : name + TabularNonNullValuesRenderer.this.getLabel();
        }

        private boolean isValidObject(Object object) {
            return !(object == null || object instanceof String && ((String)object).length() == 0 || object instanceof Collection && ((Collection)object).size() == 0 || object instanceof LocalizedString && !this.validMultiLanguage((LocalizedString)object));
        }

        private boolean validMultiLanguage(LocalizedString localizedString) {
            for (Locale locale : localizedString.getLocales()) {
                if (localizedString.getContent(locale).trim().length() <= 0) continue;
                return true;
            }
            return false;
        }
    }
}

