/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.beanutils.PropertyUtils;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLink;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;
import pt.ist.fenixWebFramework.renderers.utils.RenderKit;

public class SeparatorListRenderer
extends OutputRenderer {
    private static String DEFAULT_SEPARATOR = " > ";
    private String separator;
    private String eachSchema;
    private String eachLayout;
    private String param;
    private String link;
    private String emptyLabel;
    private Boolean targetBlank;

    public Boolean getTargetBlank() {
        return this.targetBlank;
    }

    public void setTargetBlank(Boolean targetBlank) {
        this.targetBlank = targetBlank;
    }

    public String getEmptyLabel() {
        return this.emptyLabel;
    }

    public void setEmptyLabel(String emptyLabel) {
        this.emptyLabel = emptyLabel;
    }

    public String getSeparator() {
        return this.hasSeparator() ? this.separator : DEFAULT_SEPARATOR;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    private boolean hasSeparator() {
        return !Strings.isNullOrEmpty((String)this.separator);
    }

    public String getEachSchema() {
        return this.eachSchema;
    }

    public void setEachSchema(String eachSchema) {
        this.eachSchema = eachSchema;
    }

    public String getEachLayout() {
        return this.eachLayout;
    }

    public void setEachLayout(String eachLayout) {
        this.eachLayout = eachLayout;
    }

    public String getParam() {
        return this.param;
    }

    public void setParam(String param) {
        this.param = param;
    }

    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlBlockContainer blockContainer = new HtmlBlockContainer();
                Collection objects = (Collection)object;
                Iterator iterator = objects.iterator();
                while (iterator.hasNext()) {
                    Object each = iterator.next();
                    Schema schema = RenderKit.getInstance().findSchema(SeparatorListRenderer.this.getEachSchema());
                    HtmlComponent htmlComponent = SeparatorListRenderer.this.renderValue(each, each.getClass(), schema, SeparatorListRenderer.this.getEachLayout(), null);
                    if (htmlComponent != null && SeparatorListRenderer.this.getLink() != null && !Strings.isNullOrEmpty((String)SeparatorListRenderer.this.getLink().trim()) && SeparatorListRenderer.this.getParam() != null && !Strings.isNullOrEmpty((String)SeparatorListRenderer.this.getParam().trim())) {
                        htmlComponent = this.getHtmlLink(each, htmlComponent);
                    }
                    blockContainer.addChild(htmlComponent);
                    blockContainer.addChild(iterator.hasNext() ? new HtmlText(SeparatorListRenderer.this.getSeparator()) : new HtmlText());
                }
                if (objects.isEmpty() && SeparatorListRenderer.this.getEmptyLabel() != null && !Strings.isNullOrEmpty((String)SeparatorListRenderer.this.getEmptyLabel())) {
                    blockContainer.addChild(new HtmlText(SeparatorListRenderer.this.getEmptyLabel()));
                }
                return blockContainer;
            }

            private HtmlLink getHtmlLink(Object object, HtmlComponent htmlComponent) {
                String[] split = SeparatorListRenderer.this.getParam().trim().split("/");
                String slotName = split[0];
                String paramName = split[1];
                String slotValue = this.getSlotValue(object, slotName);
                HtmlLink htmlLink = new HtmlLink();
                htmlLink.setUrl(SeparatorListRenderer.this.getLink().trim());
                htmlLink.setModuleRelative(false);
                if (SeparatorListRenderer.this.getTargetBlank() != null && SeparatorListRenderer.this.getTargetBlank().booleanValue()) {
                    htmlLink.setTarget("_blank");
                }
                htmlLink.setBody(htmlComponent);
                if (slotValue != null) {
                    htmlLink.setParameter(paramName, slotValue);
                }
                return htmlLink;
            }

            private String getSlotValue(Object object, String slotName) {
                String slotValue = null;
                try {
                    slotValue = String.valueOf(PropertyUtils.getProperty((Object)object, (String)slotName));
                }
                catch (Exception e) {
                    throw new RuntimeException("could not set param name by reading property '" + slotName + "' from object " + object, e);
                }
                return slotValue;
            }
        };
    }
}

