/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.validators;

import com.google.common.base.Strings;
import pt.ist.fenixWebFramework.renderers.components.HtmlSimpleValueComponent;
import pt.ist.fenixWebFramework.renderers.components.Validatable;
import pt.ist.fenixWebFramework.renderers.validators.HtmlChainValidator;
import pt.ist.fenixWebFramework.renderers.validators.HtmlValidator;

public class RequiredValidator
extends HtmlValidator {
    public RequiredValidator() {
    }

    public RequiredValidator(HtmlChainValidator htmlChainValidator) {
        super(htmlChainValidator);
    }

    @Override
    public void performValidation() {
        Validatable component = this.getComponent();
        if (component instanceof HtmlSimpleValueComponent) {
            if (component.getValue() == null) {
                this.setValid(false);
            } else {
                this.setValid(!component.getValue().equals(""));
            }
        } else {
            String[] values = component.getValues();
            if (values == null) {
                this.setValid(false);
            } else {
                this.setValid(values.length > 0);
            }
        }
    }

    @Override
    public boolean hasJavascriptSupport() {
        return true;
    }

    @Override
    protected String getSpecificValidatorScript() {
        return "function(element) { return $(element).attr('value').length > 0; }";
    }

    @Override
    public String getMessage() {
        if (Strings.isNullOrEmpty((String)super.getMessage())) {
            this.setMessage("renderers.validator.required");
        }
        return super.getMessage();
    }
}

