/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.converters;

import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class IntegerNumberConverter
extends Converter {
    private int base;

    public IntegerNumberConverter() {
        this.setBase(10);
    }

    public IntegerNumberConverter(int base) {
        this();
        this.setBase(base);
    }

    public int getBase() {
        return this.base;
    }

    public void setBase(int base) {
        this.base = base;
    }

    @Override
    public Object convert(Class type, Object value) {
        String numberText = ((String)value).trim();
        if (numberText.length() == 0) {
            return null;
        }
        try {
            return Integer.parseInt(numberText.trim(), this.getBase());
        }
        catch (NumberFormatException e) {
            throw new ConversionException("renderers.converter.integer", (Throwable)e, true, value);
        }
    }
}

