/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.math.BigDecimal;
import pt.ist.fenixWebFramework.renderers.NumberInputRenderer;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class BigDecimalInputRenderer
extends NumberInputRenderer {
    @Override
    protected Converter getConverter() {
        return new BigDecimalNumberConverter();
    }

    private class BigDecimalNumberConverter
    extends Converter {
        private BigDecimalNumberConverter() {
        }

        @Override
        public Object convert(Class type, Object value) {
            String numberText = ((String)value).trim().replace(',', '.');
            try {
                return numberText.length() == 0 ? null : new BigDecimal(numberText);
            }
            catch (NumberFormatException e) {
                throw new ConversionException("renderers.converter.bigdecimal", (Throwable)e, true, value);
            }
        }
    }
}

