/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.htmlEditor;

import pt.ist.fenixWebFramework.rendererExtensions.htmlEditor.JsoupSafeHtmlConverter;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlTextArea;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaSlot;

public class RichTextInputRenderer
extends InputRenderer {
    private Integer columns;
    private Integer rows;
    private boolean safe;

    public RichTextInputRenderer() {
        this.setColumns(50);
        this.setRows(10);
    }

    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
    }

    public Integer getRows() {
        return this.rows;
    }

    public void setRows(Integer rows) {
        this.rows = rows;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public void setSafe(boolean safe) {
        this.safe = safe;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                HtmlTextArea textArea = new HtmlTextArea();
                textArea.setValue((String)object);
                textArea.setColumns(RichTextInputRenderer.this.getColumns());
                textArea.setRows(RichTextInputRenderer.this.getRows());
                textArea.addClass("form-control");
                textArea.setAttribute("bennu-html-editor", "true");
                textArea.setTargetSlot(((MetaSlot)RichTextInputRenderer.this.getInputContext().getMetaObject()).getKey());
                if (RichTextInputRenderer.this.isSafe()) {
                    textArea.setConverter(new JsoupSafeHtmlConverter());
                }
                RichTextInputRenderer.this.getInputContext().requireToolkit();
                return textArea;
            }
        };
    }
}

