/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.utils;

import com.google.common.collect.ImmutableList;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.PageContext;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.fenixedu.commons.i18n.I18N;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.fenixWebFramework.rendererExtensions.util.IPresentableEnum;
import pt.ist.fenixWebFramework.renderers.components.state.ComponentLifeCycle;
import pt.ist.fenixWebFramework.renderers.components.state.IViewState;
import pt.ist.fenixWebFramework.renderers.components.state.LifeCycleConstants;
import pt.ist.fenixWebFramework.renderers.plugin.RenderersRequestProcessorImpl;
import pt.ist.fenixWebFramework.renderers.utils.ModuleResolver;
import pt.ist.fenixWebFramework.renderers.utils.RenderersBundleResolver;
import pt.ist.fenixWebFramework.renderers.utils.RenderersMessageSource;
import pt.ist.fenixWebFramework.renderers.utils.ResourceBundleMessageSource;

public class RenderUtils {
    private static final Logger logger = LoggerFactory.getLogger(RenderUtils.class);
    private static RenderersBundleResolver resolver = ResourceBundleMessageSource::new;
    private static ModuleResolver moduleResolver = new ModuleResolver(){

        @Override
        public String maybeResolveModule(HttpServletRequest request) {
            return null;
        }

        @Override
        public String maybeResolveActionMapping(String mapping, PageContext pageCtx) {
            return ((HttpServletRequest)pageCtx.getRequest()).getServletPath();
        }
    };
    public static String RESOURCE_LABEL_PREFIX = "label";
    private static final String[] fields = new String[]{"description"};

    public static void setModuleResolver(ModuleResolver res) {
        moduleResolver = Objects.requireNonNull(res);
    }

    public static void setBundleResolver(RenderersBundleResolver res) {
        resolver = Objects.requireNonNull(res);
    }

    public static String getSlotLabel(Class objectType, String slotName, String bundle, String key, String ... args) {
        String label = null;
        if (key != null) {
            label = RenderUtils.getResourceString(bundle, key, args);
        }
        if (label != null) {
            return label;
        }
        if (key != null) {
            logger.debug("Key specified for slot '{}' does not exist: {}", (Object)slotName, (Object)key);
        }
        if ((label = RenderUtils.readClassResourceString(bundle, objectType, slotName, args)) != null) {
            return label;
        }
        label = RenderUtils.getResourceString(bundle, RESOURCE_LABEL_PREFIX + "." + slotName, args);
        if (label != null) {
            return label;
        }
        label = RenderUtils.getResourceString(bundle, slotName, args);
        if (label != null) {
            return label;
        }
        if (slotName.contains(".")) {
            label = RenderUtils.getResourceString(bundle, slotName.substring(slotName.lastIndexOf(".") + 1), args);
        }
        if (label != null) {
            return label;
        }
        return slotName;
    }

    private static String readClassResourceString(String bundle, Class objectType, String slotName, String ... args) {
        String label = null;
        for (Class clazzIter = objectType; clazzIter != null && !Object.class.equals((Object)clazzIter); clazzIter = clazzIter.getSuperclass()) {
            label = RenderUtils.getResourceString(bundle, RESOURCE_LABEL_PREFIX + "." + clazzIter.getName() + "." + slotName);
            if (label == null) continue;
            return label;
        }
        return null;
    }

    public static String getResourceString(String key) {
        return RenderUtils.getResourceString(null, key);
    }

    public static String getEnumString(Enum enumerate) {
        return RenderUtils.getEnumString(enumerate, null);
    }

    public static String getEnumString(Enum enumerate, String bundle) {
        Enum e = enumerate;
        String description = null;
        Class<?> enumClass = e.getClass();
        if (IPresentableEnum.class.isAssignableFrom(enumClass)) {
            return ((IPresentableEnum)((Object)enumerate)).getLocalizedName();
        }
        if (bundle == null) {
            bundle = "ENUMERATION_RESOURCES";
        }
        if (!enumClass.isEnum() && Enum.class.isAssignableFrom(enumClass)) {
            enumClass = enumClass.getEnclosingClass();
        }
        String fullPrefix = enumClass.getName();
        description = RenderUtils.getEnumStringFromFields(e);
        if (description == null) {
            description = RenderUtils.getResourceString(bundle, fullPrefix + "." + e.name());
        }
        if (description == null) {
            String simplePrefix = enumClass.getSimpleName();
            description = RenderUtils.getResourceString(bundle, simplePrefix + "." + e.name());
        }
        if (description == null) {
            description = RenderUtils.getResourceString(bundle, e.toString());
        }
        if (description == null) {
            description = RenderUtils.getResourceString(e.toString());
        }
        if (description == null) {
            description = e.toString();
        }
        return description;
    }

    private static String getEnumStringFromFields(Enum oneEnum) {
        for (String field : fields) {
            String toInspect;
            try {
                toInspect = BeanUtils.getProperty((Object)oneEnum, (String)field);
            }
            catch (Exception e) {
                continue;
            }
            if (toInspect == null) continue;
            return toInspect;
        }
        return null;
    }

    public static String getResourceString(String bundle, String key) {
        return RenderUtils.getResourceString(bundle, key, null);
    }

    public static String getResourceString(String bundle, String key, Object[] args) {
        RenderersMessageSource resources = RenderUtils.getMessageResources(bundle);
        Optional<String> message = resources.getMessage(I18N.getLocale(), key);
        if (message.isPresent()) {
            return RenderUtils.formatMessage(message.get(), args);
        }
        RenderersMessageSource rendererResources = RenderUtils.getMessageResources("resources.RendererResources");
        message = rendererResources.getMessage(I18N.getLocale(), key);
        if (message.isPresent()) {
            return RenderUtils.formatMessage(message.get(), args);
        }
        return null;
    }

    private static final String formatMessage(String message, Object[] args) {
        if (args == null) {
            return message;
        }
        for (int i = 0; i < args.length; ++i) {
            message = message.replaceAll("\\{" + i + "\\}", args[i] == null ? "" : Matcher.quoteReplacement(Objects.toString(args[i])));
        }
        return message;
    }

    private static Locale getLocale() {
        return I18N.getLocale();
    }

    public static RenderersMessageSource getMessageResources(String bundle) {
        return resolver.resolveBundle(bundle);
    }

    public static String getFormatedResourceString(String key, Object ... args) {
        String text = RenderUtils.getResourceString(key);
        if (text == null) {
            return key;
        }
        MessageFormat format = new MessageFormat(text);
        return format.format(args);
    }

    public static String getFormatedResourceString(String bundle, String key, Object ... args) {
        String text = RenderUtils.getResourceString(bundle, key);
        if (text == null) {
            return key;
        }
        MessageFormat format = new MessageFormat(text);
        return format.format(args);
    }

    public static String getFormattedProperties(String format, Object object) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder builder = new StringBuilder();
        if (format != null) {
            int index;
            int lastIndex = 0;
            while ((index = format.indexOf("${", lastIndex)) != -1) {
                int end = format.indexOf("}", index + 2);
                if (end == -1) {
                    throw new RuntimeException("'" + format + "':unmatched group at pos " + index);
                }
                builder.append(format.substring(lastIndex, index));
                lastIndex = end + 1;
                if (end - index == 2) {
                    builder.append("%s");
                    args.add(object);
                    continue;
                }
                String spec = format.substring(index + 2, end);
                String[] parts = spec.split(",");
                String property = parts[0];
                if (parts.length > 1) {
                    builder.append("%" + parts[1]);
                } else {
                    builder.append("%s");
                }
                try {
                    Object value = PropertyUtils.getProperty((Object)object, (String)property);
                    args.add(value);
                }
                catch (Exception e) {
                    try {
                        Object value = RenderUtils.findPropertyFromRequest(property);
                        args.add(value);
                    }
                    catch (RuntimeException rt) {
                        throw rt;
                    }
                    catch (Exception e1) {
                        throw new RuntimeException("could not retrieve property '" + property + "' for object " + object, e);
                    }
                }
            }
            builder.append(format.substring(lastIndex));
        }
        return String.format(RenderUtils.getLocale(), builder.toString(), args.toArray());
    }

    private static Object findPropertyFromRequest(String property) throws Exception {
        HttpServletRequest currentRequest = RenderersRequestProcessorImpl.getCurrentRequest();
        if (currentRequest != null) {
            int indexOfDot = property.indexOf(46);
            String objectName = indexOfDot != -1 ? property.substring(0, indexOfDot) : property;
            String propertyName = indexOfDot != -1 ? property.substring(indexOfDot + 1) : null;
            Enumeration attributeNames = currentRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                if (!attributeNames.nextElement().equals(objectName)) continue;
                Object objectFromRequest = currentRequest.getAttribute(objectName);
                if (objectFromRequest != null && propertyName != null) {
                    try {
                        return PropertyUtils.getProperty((Object)objectFromRequest, (String)propertyName);
                    }
                    catch (Exception e1) {
                        throw new RuntimeException("could not retrieve property '" + propertyName + "' from request object " + objectName, e1);
                    }
                }
                return objectFromRequest;
            }
        }
        throw new Exception("could not retrieve property '" + property + "' from request object ");
    }

    public static void setProperties(Object target, Properties properties) {
        if (properties == null) {
            return;
        }
        for (Object property : properties.keySet()) {
            String propertyName = null;
            try {
                propertyName = (String)property;
                PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)target, (String)propertyName);
                if (desc != null) {
                    if (desc.getWriteMethod() != null) {
                        BeanUtils.copyProperty((Object)target, (String)propertyName, (Object)properties.getProperty(propertyName));
                        continue;
                    }
                    PropertyUtils.setProperty((Object)target, (String)propertyName, (Object)properties.getProperty(propertyName));
                    continue;
                }
                logger.debug("Object {} does not support property '{}'. Descriptor not found.", target, (Object)propertyName);
            }
            catch (Exception e) {
                logger.warn("The object " + target + " does not support property '" + propertyName + "'", (Throwable)e);
            }
        }
    }

    public static String getModuleRelativePath(HttpServletRequest request, String path) {
        String module = moduleResolver.maybeResolveModule(request);
        Object returnPath = module != null ? module + path : path;
        return RenderUtils.getContextRelativePath(request, (String)returnPath);
    }

    public static String getModuleRelativePath(String path) {
        return RenderUtils.getModuleRelativePath(RenderersRequestProcessorImpl.getCurrentRequest(), path);
    }

    public static String getContextRelativePath(HttpServletRequest request, String path) {
        String contextPath = request.getContextPath();
        return contextPath + path;
    }

    public static String getContextRelativePath(String path) {
        return RenderUtils.getContextRelativePath(RenderersRequestProcessorImpl.getCurrentRequest(), path);
    }

    public static <T> List<T> sortCollectionWithCriteria(Collection<? extends T> collection, String criteria) {
        if (collection == null) {
            return null;
        }
        ArrayList<? extends T> result = new ArrayList<T>(collection);
        if (criteria == null) {
            return result;
        }
        String[] singleCriterias = criteria.split(",");
        if (singleCriterias.length == 0) {
            return result;
        }
        Comparator<Object> comparator = null;
        for (String singleCriteria2 : singleCriterias) {
            String order;
            String slot;
            String singleCriteria = singleCriteria2.trim();
            if (singleCriteria.length() <= 0) continue;
            int orderIndex = singleCriteria.indexOf("=");
            if (orderIndex != -1) {
                slot = singleCriteria.substring(0, orderIndex);
                order = singleCriteria.substring(orderIndex + 1);
            } else {
                slot = singleCriteria;
                order = null;
            }
            boolean ascending = order == null || order.startsWith("asc");
            comparator = RenderUtils.createCompositeComparator(comparator, slot, ascending);
        }
        if (comparator != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    public static <T> List<T> sortCollectionWithCriteria(T[] collection, String criteria) {
        if (collection == null) {
            return null;
        }
        List<T> result = Arrays.asList(collection);
        return RenderUtils.sortCollectionWithCriteria(result, criteria);
    }

    private static Comparator<Object> createCompositeComparator(final Comparator<Object> comparator, final String slot, final boolean ascending) {
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                int slotComparison = comparator != null ? comparator.compare(o1, o2) : 0;
                if (slotComparison != 0) {
                    return slotComparison;
                }
                slotComparison = ascending ? this.compareSlots(o1, o2, slot) : this.compareSlots(o2, o1, slot);
                return slotComparison;
            }

            private int compareSlots(Object o1, Object o2, String slot2) {
                try {
                    Object slotObj1 = PropertyUtils.getProperty((Object)o1, (String)slot2);
                    Object slotObj2 = PropertyUtils.getProperty((Object)o2, (String)slot2);
                    if (slotObj1 == null && slotObj2 == null) {
                        return 0;
                    }
                    if (slotObj1 == null) {
                        return 1;
                    }
                    if (slotObj2 == null) {
                        return -1;
                    }
                    if (String.class.isAssignableFrom(PropertyUtils.getPropertyType((Object)o1, (String)slot2))) {
                        return new BeanComparator(slot2, (Comparator)Collator.getInstance()).compare(o1, o2);
                    }
                    return new BeanComparator(slot2).compare(o1, o2);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static IViewState getViewState() {
        List viewStates = (List)RenderersRequestProcessorImpl.getCurrentRequest().getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        if (viewStates != null && viewStates.size() > 0) {
            return (IViewState)viewStates.get(0);
        }
        return null;
    }

    public static IViewState getViewState(String id) {
        List viewStates = (List)RenderersRequestProcessorImpl.getCurrentRequest().getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        if (viewStates != null) {
            for (IViewState state : viewStates) {
                if (!id.equals(state.getId())) continue;
                return state;
            }
        }
        return null;
    }

    public static void setViewState(IViewState viewState) throws InstantiationException, IllegalAccessException, IOException, ClassNotFoundException {
        HttpServletRequest currentRequest = RenderersRequestProcessorImpl.getCurrentRequest();
        ArrayList<IViewState> viewStates = new ArrayList<IViewState>();
        viewStates.add(viewState);
        ComponentLifeCycle.getInstance().restoreComponent(viewState);
        ComponentLifeCycle.getInstance().prepareDestination(viewStates, currentRequest);
    }

    public static void invalidateViewState() {
        RenderersRequestProcessorImpl.getCurrentRequest().setAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME, null);
    }

    public static boolean invalidateViewState(String id) {
        List viewStates = (List)RenderersRequestProcessorImpl.getCurrentRequest().getAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME);
        if (viewStates == null || viewStates.isEmpty()) {
            return false;
        }
        if (viewStates.size() == 1 && id.equals(((IViewState)viewStates.get(0)).getId())) {
            RenderUtils.invalidateViewState();
            return true;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (IViewState viewState : viewStates) {
            if (id.equals(viewState.getId())) continue;
            builder.add((Object)viewState);
        }
        RenderersRequestProcessorImpl.getCurrentRequest().setAttribute(LifeCycleConstants.VIEWSTATE_PARAM_NAME, (Object)builder.build());
        return true;
    }

    public static String escapeId(String id) {
        return id.replace(".", "\\\\.").replaceAll(":", "\\\\\\\\:");
    }

    public static String getModule(HttpServletRequest request) {
        return moduleResolver.maybeResolveModule(request);
    }

    public static String getActionMappingURL(String mapping, PageContext pageCtx) {
        return moduleResolver.maybeResolveActionMapping(mapping, pageCtx);
    }

    public static String getCurrentActionMappingURL(PageContext pageCtx) {
        return moduleResolver.maybeResolveActionMapping(null, pageCtx);
    }
}

