/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers.layouts;

import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.jsp.PageContext;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlLabel;
import pt.ist.fenixWebFramework.renderers.components.HtmlScript;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;

public abstract class FormLayout
extends Layout {
    @Override
    public HtmlComponent createComponent(Object object, Class type) {
        HtmlBlockContainer topLevelContainer = new HtmlBlockContainer();
        int rowNumber = this.getNumberOfRows();
        for (int rowIndex = 0; rowIndex < rowNumber; ++rowIndex) {
            HtmlBlockContainer container = new HtmlBlockContainer();
            topLevelContainer.addChild(container);
            container.addClass("form-group");
            HtmlLabel label = new HtmlLabel(this.getLabelText(rowIndex));
            HtmlBlockContainer slotContainer = new HtmlBlockContainer();
            if (this.displayLabel()) {
                label.addClass("control-label");
                label.addClass("col-sm-2");
                container.addChild(label);
                slotContainer.addClass("col-sm-10");
            } else {
                slotContainer.addClass("col-sm-12");
            }
            container.addChild(slotContainer);
            HtmlComponent renderedSlot = this.getRenderedSlot(rowIndex);
            slotContainer.addChild(renderedSlot);
            Supplier<Optional<String>> validationErrors = this.getValidationError(rowIndex);
            slotContainer.addBlock((tag, context) -> ((Optional)validationErrors.get()).ifPresent(error -> {
                HtmlText text = new HtmlText((String)error);
                text.setClasses("help-block");
                text.setStyle("margin-bottom: 0");
                tag.addChild(text.getOwnTag((PageContext)context));
            }));
            Optional<String> helpLabel = this.getHelpLabel(rowIndex);
            slotContainer.addBlock((tag, context) -> helpLabel.ifPresent(help -> {
                tag.setAttribute("data-toggle", "tooltip");
                tag.setAttribute("title", (String)help);
                tag.setAttribute("data-placement", "bottom");
                HtmlScript script = new HtmlScript();
                script.setScript("$('[data-toggle=tooltip]').tooltip();");
                tag.addChild(script.getOwnTag((PageContext)context));
            }));
            container.addBlock((tag, context) -> ((Optional)validationErrors.get()).ifPresent(error -> tag.setAttribute("class", (String)(container.getClasses() == null ? "has-error" : container.getClasses() + " has-error"))));
            label.setFor(renderedSlot.getId());
        }
        return topLevelContainer;
    }

    public abstract int getNumberOfRows();

    public abstract String getLabelText(int var1);

    public abstract HtmlComponent getRenderedSlot(int var1);

    public abstract Supplier<Optional<String>> getValidationError(int var1);

    public Optional<String> getHelpLabel(int rowIndex) {
        return Optional.empty();
    }

    public boolean displayLabel() {
        return true;
    }
}

