/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import java.util.EnumSet;
import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class EnumSetRenderer
extends OutputRenderer {
    protected String getEnumSetDescription(EnumSet enumset) {
        Object[] enumSetArray = enumset.toArray();
        StringBuilder description = new StringBuilder();
        for (Object enumSetObject : enumSetArray) {
            String thisDescription = RenderUtils.getEnumString((Enum)enumSetObject);
            if (description.length() != 0) {
                description.append(", ");
            }
            description.append(thisDescription);
        }
        return description.toString();
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                EnumSet enumSet = (EnumSet)object;
                if (enumSet == null) {
                    return new HtmlText();
                }
                String description = EnumSetRenderer.this.getEnumSetDescription(enumSet);
                return new HtmlText(description);
            }
        };
    }
}

