/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.renderers;

import pt.ist.fenixWebFramework.renderers.OutputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlImage;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

public class BooleanImageRenderer
extends OutputRenderer {
    private String trueIconPath;
    private String falseIconPath;
    private Boolean contextRelative;
    private Boolean nullAsFalse;

    public String getFalseIconPath() {
        return this.falseIconPath;
    }

    public void setFalseIconPath(String falseIconPath) {
        this.falseIconPath = falseIconPath;
    }

    public String getTrueIconPath() {
        return this.trueIconPath;
    }

    public void setTrueIconPath(String trueIconPath) {
        this.trueIconPath = trueIconPath;
    }

    public Boolean isContextRelative() {
        return this.contextRelative;
    }

    public void setContextRelative(Boolean contextRelative) {
        this.contextRelative = contextRelative;
    }

    @Override
    protected Layout getLayout(Object object, Class type) {
        return new Layout(){

            @Override
            public HtmlComponent createComponent(Object object, Class type) {
                Boolean booleanValue = (Boolean)object;
                if (booleanValue == null) {
                    if (!BooleanImageRenderer.this.isNullAsFalse().booleanValue()) {
                        return new HtmlText();
                    }
                    booleanValue = false;
                }
                StringBuilder pathBuilder = new StringBuilder();
                if (BooleanImageRenderer.this.contextRelative.booleanValue()) {
                    pathBuilder.append(RenderUtils.getContextRelativePath(""));
                }
                pathBuilder.append(this.getIconPath(booleanValue));
                String fullPath = pathBuilder.toString();
                HtmlImage img = new HtmlImage();
                img.setSource(fullPath);
                return img;
            }

            private String getIconPath(Boolean booleanValue) {
                return booleanValue != false ? BooleanImageRenderer.this.getTrueIconPath() : BooleanImageRenderer.this.getFalseIconPath();
            }
        };
    }

    public void setNullAsFalse(Boolean nullAsFalse) {
        this.nullAsFalse = nullAsFalse;
    }

    public Boolean isNullAsFalse() {
        return this.nullAsFalse;
    }
}

