/*
 * Decompiled with CFR 0.152.
 */
package pt.ist.fenixWebFramework.rendererExtensions.factories;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pt.ist.fenixWebFramework.rendererExtensions.factories.CreationMetaObjectKey;
import pt.ist.fenixWebFramework.rendererExtensions.factories.DomainMetaObject;
import pt.ist.fenixWebFramework.rendererExtensions.util.ObjectChange;
import pt.ist.fenixWebFramework.rendererExtensions.util.ObjectKey;
import pt.ist.fenixWebFramework.renderers.model.InstanceCreator;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectKey;
import pt.ist.fenixframework.DomainObject;

public class CreationDomainMetaObject
extends DomainMetaObject {
    private final Class type;

    public CreationDomainMetaObject(Class type) {
        this.type = type;
        this.setExternalId(null);
    }

    @Override
    public MetaObjectKey getKey() {
        return new CreationMetaObjectKey(this.getType());
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    protected Object callService(List<ObjectChange> changes) {
        Object result = super.callService(changes);
        this.setObject(((Collection)result).iterator().next());
        return result;
    }

    @Override
    protected DomainObject getPersistentObject() {
        return null;
    }

    @Override
    protected DomainMetaObject.ServicePredicateWithResult getServiceToCall(List<ObjectChange> changes) {
        return new CreationServicePredicateWithResult(changes);
    }

    public class CreationServicePredicateWithResult
    extends DomainMetaObject.ServicePredicateWithResult {
        public CreationServicePredicateWithResult(List<ObjectChange> changes) {
            super(changes);
        }

        @Override
        public Object execute() {
            InstanceCreator instanceCreator = CreationDomainMetaObject.this.getInstanceCreator();
            if (instanceCreator != null) {
                String oid = CreationDomainMetaObject.this.getExternalId();
                ObjectKey key = new ObjectKey(oid, CreationDomainMetaObject.this.getType());
                try {
                    this.changes.add(0, new ObjectChange(key, instanceCreator.getConstructor(), instanceCreator.getArgumentValues()));
                }
                catch (Exception e) {
                    throw new RuntimeException("could not find constructor for '" + CreationDomainMetaObject.this.getType().getName() + "' with arguments " + Arrays.asList(instanceCreator.getArgumentTypes()), e);
                }
            }
            return super.execute();
        }

        @Override
        protected DomainObject getNewObject(ObjectChange change) {
            try {
                Class objectClass = change.key.getType();
                if (change.constructor != null) {
                    return (DomainObject)change.constructor.newInstance(change.values);
                }
                return (DomainObject)objectClass.newInstance();
            }
            catch (Exception e) {
                if (e.getCause() instanceof Error) {
                    throw (Error)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new Error(e);
            }
        }
    }
}

